/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.annotations;

import java.lang.reflect.Modifier;
import mockit.external.asm.AnnotationVisitor;
import mockit.external.asm.ClassReader;
import mockit.external.asm.FieldVisitor;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.commons.EmptyVisitor;
import mockit.internal.ClassFile;
import mockit.internal.annotations.AnnotatedMockMethods;
import mockit.internal.annotations.MockState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedMockMethodCollector
extends EmptyVisitor {
    private static final int INVALID_FIELD_ACCESSES = 4120;
    private static final int INVALID_METHOD_ACCESSES = 5440;
    private final AnnotatedMockMethods mockMethods;
    private boolean collectingFromSuperClass;
    private String enclosingClassDescriptor;

    public AnnotatedMockMethodCollector(AnnotatedMockMethods mockMethods) {
        this.mockMethods = mockMethods;
    }

    public void collectMockMethods(Class<?> mockClass) {
        Class<?> classToCollectMocksFrom = mockClass;
        do {
            ClassReader mcReader = ClassFile.createClassFileReader(classToCollectMocksFrom.getName());
            mcReader.accept(this, true);
            classToCollectMocksFrom = classToCollectMocksFrom.getSuperclass();
            this.collectingFromSuperClass = true;
        } while (classToCollectMocksFrom != Object.class);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (!this.collectingFromSuperClass) {
            this.mockMethods.setMockClassInternalName(name);
            int p = name.lastIndexOf(36);
            if (p > 0) {
                this.enclosingClassDescriptor = "(L" + name.substring(0, p) + ";)V";
            }
        }
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 0x1018) == 0 && "it".equals(name)) {
            this.mockMethods.setWithItField(true);
        }
        return null;
    }

    @Override
    public MethodVisitor visitMethod(final int access, final String name, final String methodDesc, String signature, String[] exceptions) {
        if ((access & 0x1540) != 0) {
            return null;
        }
        if (!this.collectingFromSuperClass && this.enclosingClassDescriptor != null && "<init>".equals(name) && methodDesc.equals(this.enclosingClassDescriptor)) {
            this.mockMethods.setInnerMockClass(true);
            this.enclosingClassDescriptor = null;
        }
        return new EmptyVisitor(){

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                String nameAndDesc;
                if ("Lmockit/Mock;".equals(desc) && (nameAndDesc = AnnotatedMockMethodCollector.this.mockMethods.addMethod(AnnotatedMockMethodCollector.this.collectingFromSuperClass, name, methodDesc, Modifier.isStatic(access))) != null) {
                    return new MockAnnotationVisitor(nameAndDesc);
                }
                return this;
            }
        };
    }

    private final class MockAnnotationVisitor
    extends EmptyVisitor {
        private final String mockNameAndDesc;
        private MockState mockState;

        private MockAnnotationVisitor(String mockNameAndDesc) {
            this.mockNameAndDesc = mockNameAndDesc;
        }

        public void visit(String name, Object value) {
            if ("invocations".equals(name)) {
                this.getMockState().expectedInvocations = (Integer)value;
            } else if ("minInvocations".equals(name)) {
                this.getMockState().minExpectedInvocations = (Integer)value;
            } else if ("maxInvocations".equals(name)) {
                this.getMockState().maxExpectedInvocations = (Integer)value;
            } else {
                boolean reentrant = (Boolean)value;
                if (reentrant) {
                    this.getMockState().makeReentrant();
                }
            }
        }

        private MockState getMockState() {
            if (this.mockState == null) {
                this.mockState = new MockState(((AnnotatedMockMethodCollector)AnnotatedMockMethodCollector.this).mockMethods.realClass, this.mockNameAndDesc);
            }
            return this.mockState;
        }

        public void visitEnd() {
            if (this.mockState != null) {
                AnnotatedMockMethodCollector.this.mockMethods.addMockState(this.mockState);
            }
        }
    }
}

