/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassVisitor;
import mockit.internal.state.TestRun;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassFile {
    private final ClassReader reader;

    public static ClassReader createClassFileReader(String className) {
        byte[] fixedClassfile = TestRun.mockFixture().getFixedClassfile(className);
        if (fixedClassfile != null) {
            return new ClassReader(fixedClassfile);
        }
        try {
            return ClassFile.readClass(className);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read class file for " + className, e);
        }
    }

    public static ClassReader readClass(String className) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String classFileName = className.replace('.', '/') + ".class";
        InputStream classFile = classLoader.getResourceAsStream(classFileName);
        return new ClassReader(classFile);
    }

    public static void visitClass(String internalClassName, ClassVisitor visitor) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream classFile = classLoader.getResourceAsStream(internalClassName + ".class");
        try {
            ClassReader cr = new ClassReader(classFile);
            cr.accept(visitor, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassFile(Class<?> aClass, boolean fromLastRedefinitionIfAny) {
        byte[] classfile;
        String className = aClass.getName();
        byte[] byArray = classfile = Proxy.isProxyClass(aClass) ? TestRun.proxyClasses().getClassfile(className) : null;
        if (classfile == null && fromLastRedefinitionIfAny) {
            classfile = TestRun.mockFixture().getRedefinedClassfile(aClass);
        }
        this.reader = classfile == null ? ClassFile.createClassFileReader(className) : new ClassReader(classfile);
    }

    public ClassReader getReader() {
        return this.reader;
    }

    public byte[] getBytecode() {
        return this.reader.b;
    }
}

