/*
 * Decompiled with CFR 0.152.
 */
package mockit.external.hamcrest.core;

import mockit.external.hamcrest.BaseMatcher;
import mockit.external.hamcrest.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IsInstanceOf
extends BaseMatcher<Object> {
    private final Class<?> expectedClass;
    private final Class<?> matchableClass;

    public IsInstanceOf(Class<?> expectedClass) {
        this.expectedClass = expectedClass;
        this.matchableClass = IsInstanceOf.matchableClass(expectedClass);
    }

    private static Class<?> matchableClass(Class<?> expectedClass) {
        if (Boolean.TYPE.equals(expectedClass)) {
            return Boolean.class;
        }
        if (Byte.TYPE.equals(expectedClass)) {
            return Byte.class;
        }
        if (Character.TYPE.equals(expectedClass)) {
            return Character.class;
        }
        if (Double.TYPE.equals(expectedClass)) {
            return Double.class;
        }
        if (Float.TYPE.equals(expectedClass)) {
            return Float.class;
        }
        if (Integer.TYPE.equals(expectedClass)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(expectedClass)) {
            return Long.class;
        }
        if (Short.TYPE.equals(expectedClass)) {
            return Short.class;
        }
        return expectedClass;
    }

    @Override
    public boolean matches(Object item) {
        return this.matches(item, Description.NONE);
    }

    @Override
    public void describeMismatch(Object item, Description mismatchDescription) {
        this.matches(item, mismatchDescription);
    }

    private boolean matches(Object item, Description mismatchDescription) {
        if (item == null) {
            mismatchDescription.appendText("null");
            return false;
        }
        if (!this.matchableClass.isInstance(item)) {
            mismatchDescription.appendValue(item).appendText(" is a " + item.getClass().getName());
            return false;
        }
        return true;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("an instance of ").appendText(this.expectedClass.getName());
    }
}

