/*
 * Decompiled with CFR 0.152.
 */
package mockit.external.asm;

import mockit.external.asm.ByteVector;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassWriter;
import mockit.external.asm.Label;

public final class Attribute {
    public final String type;
    byte[] value;
    Attribute next;

    Attribute(String type) {
        this.type = type;
    }

    public boolean isCodeAttribute() {
        return false;
    }

    Label[] getLabels() {
        return null;
    }

    Attribute read(ClassReader cr, int off, int len) {
        Attribute attr = new Attribute(this.type);
        attr.value = new byte[len];
        System.arraycopy(cr.b, off, attr.value, 0, len);
        return attr;
    }

    private ByteVector write() {
        ByteVector v = new ByteVector();
        v.data = this.value;
        v.length = this.value.length;
        return v;
    }

    int getCount() {
        int count = 0;
        Attribute attr = this;
        while (attr != null) {
            ++count;
            attr = attr.next;
        }
        return count;
    }

    int getSize(ClassWriter cw) {
        Attribute attr = this;
        int size = 0;
        while (attr != null) {
            cw.newUTF8(attr.type);
            size += attr.write().length + 6;
            attr = attr.next;
        }
        return size;
    }

    void put(ClassWriter cw, ByteVector out) {
        Attribute attr = this;
        while (attr != null) {
            ByteVector b = attr.write();
            out.putShort(cw.newUTF8(attr.type)).putInt(b.length);
            out.putByteArray(b.data, 0, b.length);
            attr = attr.next;
        }
    }
}

