/*
 * Decompiled with CFR 0.152.
 */
package ml.rugal.sshcommon.springmvc.controller;

import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import ml.rugal.sshcommon.springmvc.util.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;

@ControllerAdvice
@Controller
public class BaseExceptionAction {
    private static final String BAD_REQUEST = "400 (Bad Request)";
    private static final String NOT_FOUND = "404 (Not Found)";
    private static final String METHOD_NOT_ALLOWED = "405 (Method Not Allowed)";
    private static final String NOT_ACCEPTABLE = "406 (Not Acceptable)";
    private static final String UNSUPPORTED_MEDIA_TYPE = "415 (Unsupported Media Type)";
    private static final String INTERNAL_SERVER_ERROR = "500 (Internal Server Error)";
    private static final Logger LOG = LoggerFactory.getLogger((String)BaseExceptionAction.class.getName());

    @RequestMapping(value={"/**"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public Message PathNotFoundHandler(HttpServletRequest request) throws NoSuchRequestHandlingMethodException {
        LOG.warn(MessageFormat.format("{0} occured, request URL: {1}, request host: {2}", NOT_FOUND, request.getRequestURI(), request.getRemoteAddr()));
        throw new NoSuchRequestHandlingMethodException(request);
    }

    @ResponseBody
    @ExceptionHandler(value={BindException.class, HttpMessageNotReadableException.class, MethodArgumentNotValidException.class, MissingServletRequestParameterException.class, MissingServletRequestPartException.class, TypeMismatchException.class})
    public Message badRequest(HttpServletRequest req, Exception e) {
        LOG.error(e.getMessage(), (Throwable)e);
        return Message.failMessage(BAD_REQUEST);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NoHandlerFoundException.class, NoSuchRequestHandlingMethodException.class})
    public Message notFound(HttpServletRequest req, Exception e) {
        LOG.warn(e.getMessage());
        return Message.failMessage(NOT_FOUND);
    }

    @ResponseBody
    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    public Message methodNotAllowed(HttpServletRequest req, Exception e) {
        LOG.error(e.getMessage(), (Throwable)e);
        return Message.failMessage(METHOD_NOT_ALLOWED);
    }

    @ResponseBody
    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public Message notAcceptable(HttpServletRequest req, Exception e) {
        LOG.error(e.getMessage(), (Throwable)e);
        return Message.failMessage(NOT_ACCEPTABLE);
    }

    @ResponseBody
    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    public Message unsupportedMediaType(HttpServletRequest req, Exception e) {
        LOG.error(e.getMessage(), (Throwable)e);
        return Message.failMessage(UNSUPPORTED_MEDIA_TYPE);
    }

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Message internalServerError(HttpServletRequest req, Exception e) {
        LOG.error(e.getMessage(), (Throwable)e);
        return Message.failMessage(INTERNAL_SERVER_ERROR);
    }
}

