/*
 * Decompiled with CFR 0.152.
 */
package ml.rugal.sshcommon.hibernate;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Updater<T> {
    private final T bean;
    private final Set<String> includeProperties = new HashSet<String>();
    private final Set<String> excludeProperties = new HashSet<String>();
    private UpdateMode mode = UpdateMode.MIDDLE;
    private static final Logger log = LoggerFactory.getLogger(Updater.class);

    public Updater(T bean) {
        this.bean = bean;
    }

    public Updater(T bean, UpdateMode mode) {
        this.bean = bean;
        this.mode = mode;
    }

    public Updater<T> setUpdateMode(UpdateMode mode) {
        this.mode = mode;
        return this;
    }

    public Updater<T> include(String property) {
        this.includeProperties.add(property);
        return this;
    }

    public Updater<T> exclude(String property) {
        this.excludeProperties.add(property);
        return this;
    }

    public boolean isUpdate(String name, Object value) {
        boolean needUpdate = false;
        if (this.mode == UpdateMode.MAX) {
            needUpdate = !this.excludeProperties.contains(name);
        } else if (this.mode == UpdateMode.MIN) {
            needUpdate = this.includeProperties.contains(name);
        } else if (this.mode == UpdateMode.MIDDLE) {
            needUpdate = value != null ? !this.excludeProperties.contains(name) : this.includeProperties.contains(name);
        }
        return needUpdate;
    }

    public T getBean() {
        return this.bean;
    }

    public Set<String> getExcludeProperties() {
        return this.excludeProperties;
    }

    public Set<String> getIncludeProperties() {
        return this.includeProperties;
    }

    public static enum UpdateMode {
        MAX,
        MIN,
        MIDDLE;

    }
}

