/*
 * Decompiled with CFR 0.152.
 */
package ml.rugal.sshcommon.hibernate;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import ml.rugal.sshcommon.hibernate.HibernateSimpleDao;
import ml.rugal.sshcommon.hibernate.Updater;
import ml.rugal.sshcommon.util.BeanUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional
public abstract class HibernateBaseDao<T, ID extends Serializable>
extends HibernateSimpleDao {
    protected T get(ID id) {
        return this.get(id, false);
    }

    protected T get(ID id, boolean lock) {
        Object entity = lock ? this.getSession().get(this.getEntityClass(), id, LockMode.UPGRADE) : this.getSession().get(this.getEntityClass(), id);
        return (T)entity;
    }

    protected List<T> findByProperty(String property, Object value) {
        Assert.hasText((String)property);
        return this.createCriteria(new Criterion[]{Restrictions.eq((String)property, (Object)value)}).list();
    }

    protected List<T> findByPropertyBefore(String property, Object value) {
        Assert.hasText((String)property);
        return this.createCriteria(new Criterion[]{Restrictions.like((String)property, (Object)(value + "%"))}).list();
    }

    protected List<T> findByPropertyVague(String property, Object value) {
        Assert.hasText((String)property);
        return this.createCriteria(new Criterion[]{Restrictions.like((String)property, (Object)("%" + value + "%"))}).list();
    }

    protected List<T> findByPropertyAfter(String property, Object value) {
        Assert.hasText((String)property);
        return this.createCriteria(new Criterion[]{Restrictions.like((String)property, (Object)("%" + value))}).list();
    }

    protected T findUniqueByProperty(String property, Object value) {
        Assert.hasText((String)property);
        Assert.notNull((Object)value);
        return (T)this.createCriteria(new Criterion[]{Restrictions.eq((String)property, (Object)value)}).uniqueResult();
    }

    protected int countByProperty(String property, Object value) {
        Assert.hasText((String)property);
        Assert.notNull((Object)value);
        return ((Number)this.createCriteria(new Criterion[]{Restrictions.eq((String)property, (Object)value)}).setProjection(Projections.rowCount()).uniqueResult()).intValue();
    }

    protected List findByCriteria(Criterion ... criterion) {
        return this.createCriteria(criterion).list();
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public T updateByUpdater(Updater<T> updater) {
        ClassMetadata cm = this.sessionFactory.getClassMetadata(this.getEntityClass());
        T bean = updater.getBean();
        Object po = this.getSession().get(this.getEntityClass(), cm.getIdentifier(bean));
        this.updaterCopyToPersistentObject(updater, po, cm);
        return (T)po;
    }

    private void updaterCopyToPersistentObject(Updater<T> updater, T po, ClassMetadata cm) {
        String[] propNames = cm.getPropertyNames();
        String identifierName = cm.getIdentifierPropertyName();
        T bean = updater.getBean();
        for (String propName : propNames) {
            if (propName.equals(identifierName)) continue;
            try {
                Object value = BeanUtils.getSimpleProperty(bean, propName);
                if (!updater.isUpdate(propName, value)) continue;
                cm.setPropertyValue(po, propName, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | HibernateException e) {
                throw new RuntimeException("copy property to persistent object failed: '" + propName + "'", e);
            }
        }
    }

    protected Criteria createCriteria(Criterion ... criterions) {
        Criteria criteria = this.getSession().createCriteria(this.getEntityClass());
        for (Criterion c : criterions) {
            criteria.add(c);
        }
        return criteria;
    }

    protected abstract Class<T> getEntityClass();
}

