/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xkcoding.http.HttpUtil;
import com.xkcoding.http.support.HttpHeader;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.IpUtils;
import me.zhyd.oauth.utils.StringUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthWeiboRequest
extends AuthDefaultRequest {
    public AuthWeiboRequest(AuthConfig config) {
        super(config, AuthDefaultSource.WEIBO);
    }

    public AuthWeiboRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.WEIBO, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        String response = this.doPostAuthorizationCode(authCallback.getCode());
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        if (accessTokenObject.containsKey((Object)"error")) {
            throw new AuthException(accessTokenObject.getString("error_description"));
        }
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).uid(accessTokenObject.getString("uid")).openId(accessTokenObject.getString("uid")).expireIn(accessTokenObject.getIntValue("expires_in")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        String uid = authToken.getUid();
        String oauthParam = String.format("uid=%s&access_token=%s", uid, accessToken);
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Authorization", "OAuth2 " + oauthParam);
        httpHeader.add("API-RemoteIP", IpUtils.getLocalIp());
        String userInfo = HttpUtil.get((String)this.userInfoUrl(authToken), null, (HttpHeader)httpHeader, (boolean)false);
        JSONObject object = JSONObject.parseObject((String)userInfo);
        if (object.containsKey((Object)"error")) {
            throw new AuthException(object.getString("error"));
        }
        return AuthUser.builder().uuid(object.getString("id")).username(object.getString("name")).avatar(object.getString("profile_image_url")).blog(StringUtils.isEmpty(object.getString("url")) ? "https://weibo.com/" + object.getString("profile_url") : object.getString("url")).nickname(object.getString("screen_name")).location(object.getString("location")).remark(object.getString("description")).gender(AuthUserGender.getRealGender(object.getString("gender"))).token(authToken).source(this.source.toString()).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("uid", authToken.getUid()).build();
    }

    @Override
    public AuthResponse revoke(AuthToken authToken) {
        String response = this.doGetRevoke(authToken);
        JSONObject object = JSONObject.parseObject((String)response);
        if (object.containsKey((Object)"error")) {
            return AuthResponse.builder().code(AuthResponseStatus.FAILURE.getCode()).msg(object.getString("error")).build();
        }
        AuthResponseStatus status = object.getBooleanValue("result") ? AuthResponseStatus.SUCCESS : AuthResponseStatus.FAILURE;
        return AuthResponse.builder().code(status.getCode()).msg(status.getMsg()).build();
    }
}

