/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xkcoding.http.HttpUtil;
import com.xkcoding.http.support.HttpHeader;
import com.xkcoding.http.util.MapUtil;
import java.util.Map;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthStackOverflowRequest
extends AuthDefaultRequest {
    public AuthStackOverflowRequest(AuthConfig config) {
        super(config, AuthDefaultSource.STACK_OVERFLOW);
    }

    public AuthStackOverflowRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.STACK_OVERFLOW, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        String accessTokenUrl = this.accessTokenUrl(authCallback.getCode());
        Map form = MapUtil.parseStringToMap((String)accessTokenUrl, (boolean)false);
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Content-Type", "application/x-www-form-urlencoded");
        String response = HttpUtil.post((String)accessTokenUrl, (Map)form, (HttpHeader)httpHeader, (boolean)false);
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).expireIn(accessTokenObject.getIntValue("expires")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String userInfoUrl = UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("site", "stackoverflow").queryParam("key", this.config.getStackOverflowKey()).build();
        String response = HttpUtil.get((String)userInfoUrl);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        JSONObject userObj = object.getJSONArray("items").getJSONObject(0);
        return AuthUser.builder().uuid(userObj.getString("user_id")).avatar(userObj.getString("profile_image")).location(userObj.getString("location")).nickname(userObj.getString("display_name")).blog(userObj.getString("website_url")).gender(AuthUserGender.UNKNOWN).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("scope", "read_inbox").queryParam("state", this.getRealState(state)).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new AuthException(object.getString("error_description"));
        }
    }
}

