/*
 * Decompiled with CFR 0.152.
 */
package me.relex.photodraweeview;

import android.graphics.RectF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.view.DraweeView;
import me.relex.photodraweeview.Attacher;

public class DefaultOnDoubleTapListener
implements GestureDetector.OnDoubleTapListener {
    protected Attacher mAttacher;

    public DefaultOnDoubleTapListener(Attacher attacher) {
        this.setPhotoDraweeViewAttacher(attacher);
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        float y;
        float x;
        RectF displayRect;
        if (this.mAttacher == null) {
            return false;
        }
        DraweeView<GenericDraweeHierarchy> draweeView = this.mAttacher.getDraweeView();
        if (draweeView == null) {
            return false;
        }
        if (this.mAttacher.getOnPhotoTapListener() != null && null != (displayRect = this.mAttacher.getDisplayRect()) && displayRect.contains(x = e.getX(), y = e.getY())) {
            float xResult = (x - displayRect.left) / displayRect.width();
            float yResult = (y - displayRect.top) / displayRect.height();
            this.mAttacher.getOnPhotoTapListener().onPhotoTap((View)draweeView, xResult, yResult);
            return true;
        }
        if (this.mAttacher.getOnViewTapListener() != null) {
            this.mAttacher.getOnViewTapListener().onViewTap((View)draweeView, e.getX(), e.getY());
            return true;
        }
        return false;
    }

    public boolean onDoubleTap(MotionEvent event) {
        if (this.mAttacher == null) {
            return false;
        }
        try {
            float scale = this.mAttacher.getScale();
            float x = event.getX();
            float y = event.getY();
            if (scale < this.mAttacher.getMediumScale()) {
                this.mAttacher.setScale(this.mAttacher.getMediumScale(), x, y, true);
            } else if (scale >= this.mAttacher.getMediumScale() && scale < this.mAttacher.getMaximumScale()) {
                this.mAttacher.setScale(this.mAttacher.getMaximumScale(), x, y, true);
            } else {
                this.mAttacher.setScale(this.mAttacher.getMinimumScale(), x, y, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean onDoubleTapEvent(MotionEvent event) {
        return false;
    }

    public void setPhotoDraweeViewAttacher(Attacher attacher) {
        this.mAttacher = attacher;
    }
}

