/*
 * Decompiled with CFR 0.152.
 */
package me.joshlarson.json;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import me.joshlarson.json.JSONArray;
import me.joshlarson.json.JSONObject;

public class JSONOutputStream
extends OutputStream {
    private final OutputStream os;
    private String indentation;
    private boolean compact;

    public JSONOutputStream(OutputStream os) {
        this.os = os;
        this.indentation = "    ";
        this.compact = false;
    }

    public void setIndentation(String indentation) {
        this.indentation = indentation;
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
    }

    public void writeObject(JSONObject obj) throws IOException {
        this.writeObject(obj, 0);
    }

    public void writeArray(JSONArray array) throws IOException {
        this.writeArray(array, 0);
    }

    private void writeObject(JSONObject obj, int depth) throws IOException {
        this.write(123);
        if (!this.compact) {
            this.write(10);
        }
        int i = 0;
        Set<String> keys = obj.keySet();
        for (String key : keys) {
            if (!this.compact) {
                this.writeIndentation(depth + 1);
            }
            this.writeStringSafe("\"" + this.escapeString(key) + "\":");
            if (!this.compact) {
                this.write(32);
            }
            this.writeValue(obj.get(key), depth + 1);
            if (i + 1 < keys.size()) {
                this.write(44);
            }
            if (!this.compact) {
                this.write(10);
            }
            ++i;
        }
        if (!this.compact) {
            this.writeIndentation(depth);
        }
        this.write(125);
    }

    private void writeArray(JSONArray array, int depth) throws IOException {
        this.write(91);
        if (!this.compact) {
            this.write(10);
        }
        for (int i = 0; i < array.size(); ++i) {
            if (!this.compact) {
                this.writeIndentation(depth + 1);
            }
            Object o = array.get(i);
            this.writeValue(o, depth + 1);
            if (i + 1 < array.size()) {
                this.write(44);
            }
            if (this.compact) continue;
            this.write(10);
        }
        if (!this.compact) {
            this.writeIndentation(depth);
        }
        this.write(93);
    }

    private void writeValue(Object o, int depth) throws IOException {
        if (o instanceof String) {
            this.writeStringSafe("\"" + this.escapeString((String)o) + "\"");
        } else if (o instanceof Number) {
            this.writeNumber((Number)o);
        } else if (o instanceof Boolean) {
            this.writeString(o.toString());
        } else if (o == null) {
            this.writeString("null");
        } else if (o instanceof JSONObject) {
            this.writeObject((JSONObject)o, depth);
        } else if (o instanceof JSONArray) {
            this.writeArray((JSONArray)o, depth);
        }
    }

    private void writeNumber(Number n) throws IOException {
        if (n instanceof Double && (Double.isNaN((Double)n) || Double.isInfinite((Double)n))) {
            this.write(48);
            return;
        }
        if (n instanceof Float && (Float.isNaN(((Float)n).floatValue()) || Float.isInfinite(((Float)n).floatValue()))) {
            this.write(48);
            return;
        }
        this.writeString(n.toString());
    }

    private void writeIndentation(int depth) throws IOException {
        for (int i = 0; i < depth; ++i) {
            this.writeString(this.indentation);
        }
    }

    private void writeString(String str) throws IOException {
        for (int i = 0; i < str.length(); ++i) {
            this.write(str.charAt(i));
        }
    }

    private void writeStringSafe(String str) throws IOException {
        this.write(str.getBytes(StandardCharsets.UTF_8));
    }

    private String escapeString(String str) {
        StringBuilder builder = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\' || c == '\"') {
                builder.append('\\');
                builder.append(c);
                continue;
            }
            if (c <= '\u001f') {
                builder.append('\\');
                switch (c) {
                    case '\n': {
                        builder.append('n');
                        break;
                    }
                    case '\r': {
                        builder.append('r');
                        break;
                    }
                    case '\t': {
                        builder.append('t');
                        break;
                    }
                    case '\b': {
                        builder.append('b');
                        break;
                    }
                    default: {
                        builder.append(String.format("u%04X", c));
                        break;
                    }
                }
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.os.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }
}

