/*
 * Decompiled with CFR 0.152.
 */
package me.joshlarson.json;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import me.joshlarson.json.JSONArray;
import me.joshlarson.json.JSONException;
import me.joshlarson.json.JSONObject;

public class JSONInputStream
extends InputStream {
    private final InputStream is;
    private final byte[] buffer;
    private int bufferPos;
    private int bufferSize;
    private char peek;
    private boolean hasPeek;
    private boolean previousTokenString;

    public JSONInputStream(String str) {
        this(new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8)));
    }

    public JSONInputStream(InputStream is) {
        this.is = is;
        this.buffer = new byte[256];
        this.bufferPos = 0;
        this.bufferSize = 0;
        this.peek = '\u0000';
        this.hasPeek = false;
        this.previousTokenString = false;
    }

    public JSONObject readObject() throws IOException, JSONException {
        this.readAssert(this.getNextToken().equals("{"), "JSONObject must start with '{'");
        return this.getNextObjectInternal();
    }

    public JSONArray readArray() throws IOException, JSONException {
        this.readAssert(this.getNextToken().equals("["), "JSONArray must start with '['");
        return this.getNextArrayInternal();
    }

    private JSONObject getNextObjectInternal() throws IOException, JSONException {
        JSONObject obj = new JSONObject();
        String token = this.getNextToken();
        while (!token.equals("}")) {
            String key = token;
            this.readAssert(this.getNextToken().equals(":"), "Attributes must be key-value pairs separated by ':'");
            token = this.getNextToken();
            if (this.previousTokenString) {
                obj.put(key, token);
            } else if (token.equals("null")) {
                obj.putNull(key);
            } else if (token.equals("false")) {
                obj.put(key, false);
            } else if (token.equals("true")) {
                obj.put(key, true);
            } else if (token.equals("[")) {
                obj.put(key, this.getNextArrayInternal());
            } else if (token.equals("{")) {
                obj.put(key, this.getNextObjectInternal());
            } else {
                try {
                    if (token.indexOf(46) != -1) {
                        obj.put(key, Double.valueOf(token));
                    } else {
                        obj.put(key, Long.valueOf(token));
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            if ((token = this.getNextToken()).equals("}")) continue;
            this.readAssert(token.equals(","), "Attributes must be key-value pairs enumerated by ','");
            token = this.getNextToken();
        }
        return obj;
    }

    private JSONArray getNextArrayInternal() throws IOException, JSONException {
        JSONArray array = new JSONArray();
        String token = this.getNextToken();
        while (!token.equals("]")) {
            if (this.previousTokenString) {
                array.add(token);
            } else if (token.equals("null")) {
                array.addNull();
            } else if (token.equals("false")) {
                array.add(false);
            } else if (token.equals("true")) {
                array.add(true);
            } else if (token.equals("[")) {
                array.add(this.getNextArrayInternal());
            } else if (token.equals("{")) {
                array.add(this.getNextObjectInternal());
            } else {
                try {
                    if (token.indexOf(46) != -1) {
                        array.add(Double.valueOf(token));
                    } else {
                        array.add(Long.valueOf(token));
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            if ((token = this.getNextToken()).equals("]")) continue;
            this.readAssert(token.equals(","), "Values must be enumerated by ','");
            token = this.getNextToken();
        }
        return array;
    }

    private String getNextToken() throws IOException, JSONException {
        char c = this.ingestWhitespace();
        this.previousTokenString = false;
        if (c == '\u0000') {
            return "";
        }
        if (c == '{' || c == '[' || c == '}' || c == ']' || c == ',' || c == ':') {
            return Character.toString(c);
        }
        StringBuilder builder = new StringBuilder();
        if (c == '\"') {
            this.getNextTokenString(builder);
            this.previousTokenString = true;
        } else {
            builder.append(c);
            this.getNextTokenOther(builder);
        }
        return builder.toString();
    }

    private void readAssert(boolean val, String message) throws JSONException {
        if (!val) {
            throw new JSONException(message);
        }
    }

    private void getNextTokenString(StringBuilder builder) throws IOException, JSONException {
        int c = this.readChar();
        boolean prevEscape = false;
        block8: while (c != 34 || prevEscape) {
            if (c != 92 || prevEscape) {
                builder.append((char)c);
            }
            prevEscape = c == 92 && !prevEscape;
            c = this.readChar();
            if (!prevEscape) continue;
            switch (c) {
                case 110: {
                    c = 10;
                    continue block8;
                }
                case 114: {
                    c = 13;
                    continue block8;
                }
                case 116: {
                    c = 9;
                    continue block8;
                }
                case 98: {
                    c = 8;
                    continue block8;
                }
                case 117: {
                    c = (char)Integer.valueOf("" + this.readChar() + this.readChar() + this.readChar() + this.readChar(), 16).intValue();
                    continue block8;
                }
                case 34: 
                case 92: {
                    continue block8;
                }
            }
        }
    }

    private void getNextTokenOther(StringBuilder builder) throws IOException {
        while (this.isLetterOrNumber(this.peekChar())) {
            builder.append(this.readChar());
        }
    }

    private boolean isLetterOrNumber(char c) {
        return this.isUppercase(c) || this.isLowercase(c) || this.isDigit(c) || this.isExtraNumCharacter(c);
    }

    private boolean isUppercase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private boolean isLowercase(char c) {
        return c >= 'a' && c <= 'z';
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isExtraNumCharacter(char c) {
        return c == '.' || c == '-' || c == 'E' || c == 'e' || c == '+';
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    private char ingestWhitespace() throws IOException {
        char c;
        while (this.isWhitespace(c = this.readChar())) {
        }
        return c;
    }

    public char peekChar() throws IOException {
        if (this.hasPeek) {
            return this.peek;
        }
        this.peek = this.readChar();
        this.hasPeek = true;
        return this.peek;
    }

    public char readChar() throws IOException {
        if (this.hasPeek) {
            this.hasPeek = false;
            return this.peek;
        }
        int r = this.read();
        if (r == -1) {
            return '\u0000';
        }
        return (char)r;
    }

    @Override
    public int read() throws IOException {
        if (this.bufferPos >= this.bufferSize) {
            this.bufferSize = this.read(this.buffer, 0, Math.min(this.buffer.length, this.available()));
            this.bufferPos = 0;
            if (this.bufferSize < 0) {
                return -1;
            }
            if (this.bufferSize == 0) {
                return this.is.read();
            }
        }
        return this.buffer[this.bufferPos++];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.is.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.is.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public void reset() throws IOException {
        this.is.reset();
    }
}

