/*
 * Decompiled with CFR 0.152.
 */
package me.iwf.photopicker.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.ListPopupWindow;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListAdapter;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.iwf.photopicker.PhotoPickerActivity;
import me.iwf.photopicker.R;
import me.iwf.photopicker.adapter.PhotoGridAdapter;
import me.iwf.photopicker.adapter.PopupDirectoryListAdapter;
import me.iwf.photopicker.entity.Photo;
import me.iwf.photopicker.entity.PhotoDirectory;
import me.iwf.photopicker.event.OnPhotoClickListener;
import me.iwf.photopicker.fragment.ImagePagerFragment;
import me.iwf.photopicker.utils.AndroidLifecycleUtils;
import me.iwf.photopicker.utils.ImageCaptureManager;
import me.iwf.photopicker.utils.MediaStoreHelper;

public class PhotoPickerFragment
extends Fragment {
    private ImageCaptureManager captureManager;
    private PhotoGridAdapter photoGridAdapter;
    private PopupDirectoryListAdapter listAdapter;
    private List<PhotoDirectory> directories;
    private ArrayList<String> originalPhotos;
    private int SCROLL_THRESHOLD = 30;
    int column;
    public static int COUNT_MAX = 4;
    private static final String EXTRA_CAMERA = "camera";
    private static final String EXTRA_COLUMN = "column";
    private static final String EXTRA_COUNT = "count";
    private static final String EXTRA_GIF = "gif";
    private static final String EXTRA_ORIGIN = "origin";
    private ListPopupWindow listPopupWindow;
    private RequestManager mGlideRequestManager;

    public static PhotoPickerFragment newInstance(boolean showCamera, boolean showGif, boolean previewEnable, int column, int maxCount, ArrayList<String> originalPhotos) {
        Bundle args = new Bundle();
        args.putBoolean(EXTRA_CAMERA, showCamera);
        args.putBoolean(EXTRA_GIF, showGif);
        args.putBoolean("PREVIEW_ENABLED", previewEnable);
        args.putInt(EXTRA_COLUMN, column);
        args.putInt(EXTRA_COUNT, maxCount);
        args.putStringArrayList(EXTRA_ORIGIN, originalPhotos);
        PhotoPickerFragment fragment = new PhotoPickerFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
        this.mGlideRequestManager = Glide.with((Fragment)this);
        this.directories = new ArrayList<PhotoDirectory>();
        this.originalPhotos = this.getArguments().getStringArrayList(EXTRA_ORIGIN);
        this.column = this.getArguments().getInt(EXTRA_COLUMN, 3);
        boolean showCamera = this.getArguments().getBoolean(EXTRA_CAMERA, true);
        boolean previewEnable = this.getArguments().getBoolean("PREVIEW_ENABLED", true);
        this.photoGridAdapter = new PhotoGridAdapter((Context)this.getActivity(), this.mGlideRequestManager, this.directories, this.originalPhotos, this.column);
        this.photoGridAdapter.setShowCamera(showCamera);
        this.photoGridAdapter.setPreviewEnable(previewEnable);
        Bundle mediaStoreArgs = new Bundle();
        boolean showGif = this.getArguments().getBoolean(EXTRA_GIF);
        mediaStoreArgs.putBoolean("SHOW_GIF", showGif);
        MediaStoreHelper.getPhotoDirs(this.getActivity(), mediaStoreArgs, new MediaStoreHelper.PhotosResultCallback(){

            @Override
            public void onResultCallback(List<PhotoDirectory> dirs) {
                PhotoPickerFragment.this.directories.clear();
                PhotoPickerFragment.this.directories.addAll(dirs);
                PhotoPickerFragment.this.photoGridAdapter.notifyDataSetChanged();
                PhotoPickerFragment.this.listAdapter.notifyDataSetChanged();
                PhotoPickerFragment.this.adjustHeight();
            }
        });
        this.captureManager = new ImageCaptureManager((Context)this.getActivity());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.__picker_fragment_photo_picker, container, false);
        this.listAdapter = new PopupDirectoryListAdapter(this.mGlideRequestManager, this.directories);
        RecyclerView recyclerView = (RecyclerView)rootView.findViewById(R.id.rv_photos);
        StaggeredGridLayoutManager layoutManager = new StaggeredGridLayoutManager(this.column, 1);
        layoutManager.setGapStrategy(2);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        recyclerView.setAdapter((RecyclerView.Adapter)this.photoGridAdapter);
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        final Button btSwitchDirectory = (Button)rootView.findViewById(R.id.button);
        this.listPopupWindow = new ListPopupWindow((Context)this.getActivity());
        this.listPopupWindow.setWidth(-1);
        this.listPopupWindow.setAnchorView((View)btSwitchDirectory);
        this.listPopupWindow.setAdapter((ListAdapter)this.listAdapter);
        this.listPopupWindow.setModal(true);
        this.listPopupWindow.setDropDownGravity(80);
        this.listPopupWindow.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                PhotoPickerFragment.this.listPopupWindow.dismiss();
                PhotoDirectory directory = (PhotoDirectory)PhotoPickerFragment.this.directories.get(position);
                btSwitchDirectory.setText((CharSequence)directory.getName());
                PhotoPickerFragment.this.photoGridAdapter.setCurrentDirectoryIndex(position);
                PhotoPickerFragment.this.photoGridAdapter.notifyDataSetChanged();
            }
        });
        this.photoGridAdapter.setOnPhotoClickListener(new OnPhotoClickListener(){

            @Override
            public void onClick(View v, int position, boolean showCamera) {
                int index = showCamera ? position - 1 : position;
                List<String> photos = PhotoPickerFragment.this.photoGridAdapter.getCurrentPhotoPaths();
                int[] screenLocation = new int[2];
                v.getLocationOnScreen(screenLocation);
                ImagePagerFragment imagePagerFragment = ImagePagerFragment.newInstance(photos, index, screenLocation, v.getWidth(), v.getHeight());
                ((PhotoPickerActivity)PhotoPickerFragment.this.getActivity()).addImagePagerFragment(imagePagerFragment);
            }
        });
        this.photoGridAdapter.setOnCameraClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                try {
                    Intent intent = PhotoPickerFragment.this.captureManager.dispatchTakePictureIntent();
                    PhotoPickerFragment.this.startActivityForResult(intent, 1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        btSwitchDirectory.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PhotoPickerFragment.this.listPopupWindow.isShowing()) {
                    PhotoPickerFragment.this.listPopupWindow.dismiss();
                } else if (!PhotoPickerFragment.this.getActivity().isFinishing()) {
                    PhotoPickerFragment.this.adjustHeight();
                    PhotoPickerFragment.this.listPopupWindow.show();
                }
            }
        });
        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (Math.abs(dy) > PhotoPickerFragment.this.SCROLL_THRESHOLD) {
                    PhotoPickerFragment.this.mGlideRequestManager.pauseRequests();
                } else {
                    PhotoPickerFragment.this.resumeRequestsIfNotDestroyed();
                }
            }

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                if (newState == 0) {
                    PhotoPickerFragment.this.resumeRequestsIfNotDestroyed();
                }
            }
        });
        return rootView;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1 && resultCode == -1) {
            if (this.captureManager == null) {
                FragmentActivity activity = this.getActivity();
                this.captureManager = new ImageCaptureManager((Context)activity);
            }
            this.captureManager.galleryAddPic();
            if (this.directories.size() > 0) {
                String path = this.captureManager.getCurrentPhotoPath();
                PhotoDirectory directory = this.directories.get(0);
                directory.getPhotos().add(0, new Photo(path.hashCode(), path));
                directory.setCoverPath(path);
                this.photoGridAdapter.notifyDataSetChanged();
            }
        }
    }

    public PhotoGridAdapter getPhotoGridAdapter() {
        return this.photoGridAdapter;
    }

    public void onSaveInstanceState(Bundle outState) {
        this.captureManager.onSaveInstanceState(outState);
        super.onSaveInstanceState(outState);
    }

    public void onViewStateRestored(Bundle savedInstanceState) {
        this.captureManager.onRestoreInstanceState(savedInstanceState);
        super.onViewStateRestored(savedInstanceState);
    }

    public ArrayList<String> getSelectedPhotoPaths() {
        return this.photoGridAdapter.getSelectedPhotoPaths();
    }

    public void adjustHeight() {
        if (this.listAdapter == null) {
            return;
        }
        int count = this.listAdapter.getCount();
        int n = count = count < COUNT_MAX ? count : COUNT_MAX;
        if (this.listPopupWindow != null) {
            this.listPopupWindow.setHeight(count * this.getResources().getDimensionPixelOffset(R.dimen.__picker_item_directory_height));
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.directories == null) {
            return;
        }
        for (PhotoDirectory directory : this.directories) {
            directory.getPhotoPaths().clear();
            directory.getPhotos().clear();
            directory.setPhotos(null);
        }
        this.directories.clear();
        this.directories = null;
    }

    private void resumeRequestsIfNotDestroyed() {
        if (!AndroidLifecycleUtils.canLoadImage(this)) {
            return;
        }
        this.mGlideRequestManager.resumeRequests();
    }
}

