/*
 * Decompiled with CFR 0.152.
 */
package me.iwf.photopicker.fragment;

import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.bumptech.glide.Glide;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.view.ViewHelper;
import com.nineoldandroids.view.ViewPropertyAnimator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.iwf.photopicker.R;
import me.iwf.photopicker.adapter.PhotoPagerAdapter;

public class ImagePagerFragment
extends Fragment {
    public static final String ARG_PATH = "PATHS";
    public static final String ARG_CURRENT_ITEM = "ARG_CURRENT_ITEM";
    private ArrayList<String> paths;
    private ViewPager mViewPager;
    private PhotoPagerAdapter mPagerAdapter;
    public static final long ANIM_DURATION = 200L;
    public static final String ARG_THUMBNAIL_TOP = "THUMBNAIL_TOP";
    public static final String ARG_THUMBNAIL_LEFT = "THUMBNAIL_LEFT";
    public static final String ARG_THUMBNAIL_WIDTH = "THUMBNAIL_WIDTH";
    public static final String ARG_THUMBNAIL_HEIGHT = "THUMBNAIL_HEIGHT";
    public static final String ARG_HAS_ANIM = "HAS_ANIM";
    private int thumbnailTop = 0;
    private int thumbnailLeft = 0;
    private int thumbnailWidth = 0;
    private int thumbnailHeight = 0;
    private boolean hasAnim = false;
    private final ColorMatrix colorizerMatrix = new ColorMatrix();
    private int currentItem = 0;

    public static ImagePagerFragment newInstance(List<String> paths, int currentItem) {
        ImagePagerFragment f = new ImagePagerFragment();
        Bundle args = new Bundle();
        args.putStringArray(ARG_PATH, paths.toArray(new String[paths.size()]));
        args.putInt(ARG_CURRENT_ITEM, currentItem);
        args.putBoolean(ARG_HAS_ANIM, false);
        f.setArguments(args);
        return f;
    }

    public static ImagePagerFragment newInstance(List<String> paths, int currentItem, int[] screenLocation, int thumbnailWidth, int thumbnailHeight) {
        ImagePagerFragment f = ImagePagerFragment.newInstance(paths, currentItem);
        f.getArguments().putInt(ARG_THUMBNAIL_LEFT, screenLocation[0]);
        f.getArguments().putInt(ARG_THUMBNAIL_TOP, screenLocation[1]);
        f.getArguments().putInt(ARG_THUMBNAIL_WIDTH, thumbnailWidth);
        f.getArguments().putInt(ARG_THUMBNAIL_HEIGHT, thumbnailHeight);
        f.getArguments().putBoolean(ARG_HAS_ANIM, true);
        return f;
    }

    public void setPhotos(List<String> paths, int currentItem) {
        this.paths.clear();
        this.paths.addAll(paths);
        this.currentItem = currentItem;
        this.mViewPager.setCurrentItem(currentItem);
        this.mViewPager.getAdapter().notifyDataSetChanged();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.paths = new ArrayList();
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            String[] pathArr = bundle.getStringArray(ARG_PATH);
            this.paths.clear();
            if (pathArr != null) {
                this.paths = new ArrayList<String>(Arrays.asList(pathArr));
            }
            this.hasAnim = bundle.getBoolean(ARG_HAS_ANIM);
            this.currentItem = bundle.getInt(ARG_CURRENT_ITEM);
            this.thumbnailTop = bundle.getInt(ARG_THUMBNAIL_TOP);
            this.thumbnailLeft = bundle.getInt(ARG_THUMBNAIL_LEFT);
            this.thumbnailWidth = bundle.getInt(ARG_THUMBNAIL_WIDTH);
            this.thumbnailHeight = bundle.getInt(ARG_THUMBNAIL_HEIGHT);
        }
        this.mPagerAdapter = new PhotoPagerAdapter(Glide.with((Fragment)this), this.paths);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.__picker_picker_fragment_image_pager, container, false);
        this.mViewPager = (ViewPager)rootView.findViewById(R.id.vp_photos);
        this.mViewPager.setAdapter((PagerAdapter)this.mPagerAdapter);
        this.mViewPager.setCurrentItem(this.currentItem);
        this.mViewPager.setOffscreenPageLimit(5);
        if (savedInstanceState == null && this.hasAnim) {
            ViewTreeObserver observer = this.mViewPager.getViewTreeObserver();
            observer.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    ImagePagerFragment.this.mViewPager.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    int[] screenLocation = new int[2];
                    ImagePagerFragment.this.mViewPager.getLocationOnScreen(screenLocation);
                    ImagePagerFragment.this.thumbnailLeft = ImagePagerFragment.this.thumbnailLeft - screenLocation[0];
                    ImagePagerFragment.this.thumbnailTop = ImagePagerFragment.this.thumbnailTop - screenLocation[1];
                    ImagePagerFragment.this.runEnterAnimation();
                    return true;
                }
            });
        }
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                ImagePagerFragment.this.hasAnim = ImagePagerFragment.this.currentItem == position;
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        return rootView;
    }

    private void runEnterAnimation() {
        long duration = 200L;
        ViewHelper.setPivotX((View)this.mViewPager, (float)0.0f);
        ViewHelper.setPivotY((View)this.mViewPager, (float)0.0f);
        ViewHelper.setScaleX((View)this.mViewPager, (float)((float)this.thumbnailWidth / (float)this.mViewPager.getWidth()));
        ViewHelper.setScaleY((View)this.mViewPager, (float)((float)this.thumbnailHeight / (float)this.mViewPager.getHeight()));
        ViewHelper.setTranslationX((View)this.mViewPager, (float)this.thumbnailLeft);
        ViewHelper.setTranslationY((View)this.mViewPager, (float)this.thumbnailTop);
        ViewPropertyAnimator.animate((View)this.mViewPager).setDuration(200L).scaleX(1.0f).scaleY(1.0f).translationX(0.0f).translationY(0.0f).setInterpolator((Interpolator)new DecelerateInterpolator());
        ObjectAnimator bgAnim = ObjectAnimator.ofInt((Object)this.mViewPager.getBackground(), (String)"alpha", (int[])new int[]{0, 255});
        bgAnim.setDuration(200L);
        bgAnim.start();
        ObjectAnimator colorizer = ObjectAnimator.ofFloat((Object)((Object)this), (String)"saturation", (float[])new float[]{0.0f, 1.0f});
        colorizer.setDuration(200L);
        colorizer.start();
    }

    public void runExitAnimation(final Runnable endAction) {
        if (!this.getArguments().getBoolean(ARG_HAS_ANIM, false) || !this.hasAnim) {
            endAction.run();
            return;
        }
        long duration = 200L;
        ViewPropertyAnimator.animate((View)this.mViewPager).setDuration(200L).setInterpolator((Interpolator)new AccelerateInterpolator()).scaleX((float)this.thumbnailWidth / (float)this.mViewPager.getWidth()).scaleY((float)this.thumbnailHeight / (float)this.mViewPager.getHeight()).translationX((float)this.thumbnailLeft).translationY((float)this.thumbnailTop).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                endAction.run();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        ObjectAnimator bgAnim = ObjectAnimator.ofInt((Object)this.mViewPager.getBackground(), (String)"alpha", (int[])new int[]{0});
        bgAnim.setDuration(200L);
        bgAnim.start();
        ObjectAnimator colorizer = ObjectAnimator.ofFloat((Object)((Object)this), (String)"saturation", (float[])new float[]{1.0f, 0.0f});
        colorizer.setDuration(200L);
        colorizer.start();
    }

    public void setSaturation(float value) {
        this.colorizerMatrix.setSaturation(value);
        ColorMatrixColorFilter colorizerFilter = new ColorMatrixColorFilter(this.colorizerMatrix);
        this.mViewPager.getBackground().setColorFilter((ColorFilter)colorizerFilter);
    }

    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public ArrayList<String> getPaths() {
        return this.paths;
    }

    public int getCurrentItem() {
        return this.mViewPager.getCurrentItem();
    }

    public void onDestroy() {
        super.onDestroy();
        this.paths.clear();
        this.paths = null;
        if (this.mViewPager != null) {
            this.mViewPager.setAdapter(null);
        }
    }
}

