/*
 * Decompiled with CFR 0.152.
 */
package me.iwf.photopicker.adapter;

import android.support.v7.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;
import me.iwf.photopicker.entity.Photo;
import me.iwf.photopicker.entity.PhotoDirectory;
import me.iwf.photopicker.event.Selectable;

public abstract class SelectableAdapter<VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH>
implements Selectable {
    private static final String TAG = SelectableAdapter.class.getSimpleName();
    protected List<PhotoDirectory> photoDirectories = new ArrayList<PhotoDirectory>();
    protected List<String> selectedPhotos = new ArrayList<String>();
    public int currentDirectoryIndex = 0;

    @Override
    public boolean isSelected(Photo photo) {
        return this.getSelectedPhotos().contains(photo.getPath());
    }

    @Override
    public void toggleSelection(Photo photo) {
        if (this.selectedPhotos.contains(photo.getPath())) {
            this.selectedPhotos.remove(photo.getPath());
        } else {
            this.selectedPhotos.add(photo.getPath());
        }
    }

    @Override
    public void clearSelection() {
        this.selectedPhotos.clear();
    }

    @Override
    public int getSelectedItemCount() {
        return this.selectedPhotos.size();
    }

    public void setCurrentDirectoryIndex(int currentDirectoryIndex) {
        this.currentDirectoryIndex = currentDirectoryIndex;
    }

    public List<Photo> getCurrentPhotos() {
        return this.photoDirectories.get(this.currentDirectoryIndex).getPhotos();
    }

    public List<String> getCurrentPhotoPaths() {
        ArrayList<String> currentPhotoPaths = new ArrayList<String>(this.getCurrentPhotos().size());
        for (Photo photo : this.getCurrentPhotos()) {
            currentPhotoPaths.add(photo.getPath());
        }
        return currentPhotoPaths;
    }

    public List<String> getSelectedPhotos() {
        return this.selectedPhotos;
    }
}

