/*
 * Decompiled with CFR 0.152.
 */
package me.iwf.photopicker.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.RequestManager;
import java.util.ArrayList;
import java.util.List;
import me.iwf.photopicker.R;
import me.iwf.photopicker.entity.PhotoDirectory;

public class PopupDirectoryListAdapter
extends BaseAdapter {
    private List<PhotoDirectory> directories = new ArrayList<PhotoDirectory>();
    private RequestManager glide;

    public PopupDirectoryListAdapter(RequestManager glide, List<PhotoDirectory> directories) {
        this.directories = directories;
        this.glide = glide;
    }

    public int getCount() {
        return this.directories.size();
    }

    public PhotoDirectory getItem(int position) {
        return this.directories.get(position);
    }

    public long getItemId(int position) {
        return this.directories.get(position).hashCode();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            LayoutInflater mLayoutInflater = LayoutInflater.from((Context)parent.getContext());
            convertView = mLayoutInflater.inflate(R.layout.__picker_item_directory, parent, false);
            holder = new ViewHolder(convertView);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        holder.bindData(this.directories.get(position));
        return convertView;
    }

    private class ViewHolder {
        public ImageView ivCover;
        public TextView tvName;
        public TextView tvCount;

        public ViewHolder(View rootView) {
            this.ivCover = (ImageView)rootView.findViewById(R.id.iv_dir_cover);
            this.tvName = (TextView)rootView.findViewById(R.id.tv_dir_name);
            this.tvCount = (TextView)rootView.findViewById(R.id.tv_dir_count);
        }

        public void bindData(PhotoDirectory directory) {
            PopupDirectoryListAdapter.this.glide.load(directory.getCoverPath()).dontAnimate().thumbnail(0.1f).into(this.ivCover);
            this.tvName.setText((CharSequence)directory.getName());
            this.tvCount.setText((CharSequence)this.tvCount.getContext().getString(R.string.__picker_image_count, new Object[]{directory.getPhotos().size()}));
        }
    }
}

