/*
 * Decompiled with CFR 0.152.
 */
package me.iwf.photopicker.adapter;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import me.iwf.photopicker.R;
import me.iwf.photopicker.utils.AndroidLifecycleUtils;

public class PhotoPagerAdapter
extends PagerAdapter {
    private List<String> paths = new ArrayList<String>();
    private RequestManager mGlide;

    public PhotoPagerAdapter(RequestManager glide, List<String> paths) {
        this.paths = paths;
        this.mGlide = glide;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        final Context context = container.getContext();
        View itemView = LayoutInflater.from((Context)context).inflate(R.layout.__picker_picker_item_pager, container, false);
        ImageView imageView = (ImageView)itemView.findViewById(R.id.iv_pager);
        String path = this.paths.get(position);
        Uri uri = path.startsWith("http") ? Uri.parse((String)path) : Uri.fromFile((File)new File(path));
        boolean canLoadImage = AndroidLifecycleUtils.canLoadImage(context);
        if (canLoadImage) {
            this.mGlide.load(uri).thumbnail(0.1f).dontAnimate().dontTransform().override(800, 800).placeholder(R.drawable.__picker_ic_photo_black_48dp).error(R.drawable.__picker_ic_broken_image_black_48dp).into(imageView);
        }
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (context instanceof Activity && !((Activity)context).isFinishing()) {
                    ((Activity)context).onBackPressed();
                }
            }
        });
        container.addView(itemView);
        return itemView;
    }

    public int getCount() {
        return this.paths.size();
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
        Glide.clear((View)((View)object));
    }

    public int getItemPosition(Object object) {
        return -2;
    }
}

