/*
 * Decompiled with CFR 0.152.
 */
package me.iwf.photopicker.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import me.iwf.photopicker.R;
import me.iwf.photopicker.adapter.SelectableAdapter;
import me.iwf.photopicker.entity.Photo;
import me.iwf.photopicker.entity.PhotoDirectory;
import me.iwf.photopicker.event.OnItemCheckListener;
import me.iwf.photopicker.event.OnPhotoClickListener;
import me.iwf.photopicker.utils.AndroidLifecycleUtils;

public class PhotoGridAdapter
extends SelectableAdapter<PhotoViewHolder> {
    private LayoutInflater inflater;
    private RequestManager glide;
    private OnItemCheckListener onItemCheckListener = null;
    private OnPhotoClickListener onPhotoClickListener = null;
    private View.OnClickListener onCameraClickListener = null;
    public static final int ITEM_TYPE_CAMERA = 100;
    public static final int ITEM_TYPE_PHOTO = 101;
    private static final int COL_NUMBER_DEFAULT = 3;
    private boolean hasCamera = true;
    private boolean previewEnable = true;
    private int imageSize;
    private int columnNumber = 3;

    public PhotoGridAdapter(Context context, RequestManager requestManager, List<PhotoDirectory> photoDirectories) {
        this.photoDirectories = photoDirectories;
        this.glide = requestManager;
        this.inflater = LayoutInflater.from((Context)context);
        this.setColumnNumber(context, this.columnNumber);
    }

    public PhotoGridAdapter(Context context, RequestManager requestManager, List<PhotoDirectory> photoDirectories, ArrayList<String> orginalPhotos, int colNum) {
        this(context, requestManager, photoDirectories);
        this.setColumnNumber(context, colNum);
        this.selectedPhotos = new ArrayList();
        if (orginalPhotos != null) {
            this.selectedPhotos.addAll(orginalPhotos);
        }
    }

    private void setColumnNumber(Context context, int columnNumber) {
        this.columnNumber = columnNumber;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        int widthPixels = metrics.widthPixels;
        this.imageSize = widthPixels / columnNumber;
    }

    public int getItemViewType(int position) {
        return this.showCamera() && position == 0 ? 100 : 101;
    }

    public PhotoViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = this.inflater.inflate(R.layout.__picker_item_photo, parent, false);
        PhotoViewHolder holder = new PhotoViewHolder(itemView);
        if (viewType == 100) {
            holder.vSelected.setVisibility(8);
            holder.ivPhoto.setScaleType(ImageView.ScaleType.CENTER);
            holder.ivPhoto.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (PhotoGridAdapter.this.onCameraClickListener != null) {
                        PhotoGridAdapter.this.onCameraClickListener.onClick(view);
                    }
                }
            });
        }
        return holder;
    }

    public void onBindViewHolder(final PhotoViewHolder holder, int position) {
        if (this.getItemViewType(position) == 101) {
            List<Photo> photos = this.getCurrentPhotos();
            final Photo photo = this.showCamera() ? photos.get(position - 1) : photos.get(position);
            boolean canLoadImage = AndroidLifecycleUtils.canLoadImage(holder.ivPhoto.getContext());
            if (canLoadImage) {
                this.glide.load(new File(photo.getPath())).centerCrop().dontAnimate().thumbnail(0.5f).override(this.imageSize, this.imageSize).placeholder(R.drawable.__picker_ic_photo_black_48dp).error(R.drawable.__picker_ic_broken_image_black_48dp).into(holder.ivPhoto);
            }
            final boolean isChecked = this.isSelected(photo);
            holder.vSelected.setSelected(isChecked);
            holder.ivPhoto.setSelected(isChecked);
            holder.ivPhoto.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (PhotoGridAdapter.this.onPhotoClickListener != null) {
                        int pos = holder.getAdapterPosition();
                        if (PhotoGridAdapter.this.previewEnable) {
                            PhotoGridAdapter.this.onPhotoClickListener.onClick(view, pos, PhotoGridAdapter.this.showCamera());
                        } else {
                            holder.vSelected.performClick();
                        }
                    }
                }
            });
            holder.vSelected.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    int pos = holder.getAdapterPosition();
                    boolean isEnable = true;
                    if (PhotoGridAdapter.this.onItemCheckListener != null) {
                        isEnable = PhotoGridAdapter.this.onItemCheckListener.OnItemCheck(pos, photo, isChecked, PhotoGridAdapter.this.getSelectedPhotos().size());
                    }
                    if (isEnable) {
                        PhotoGridAdapter.this.toggleSelection(photo);
                        PhotoGridAdapter.this.notifyItemChanged(pos);
                    }
                }
            });
        } else {
            holder.ivPhoto.setImageResource(R.drawable.__picker_camera);
        }
    }

    public int getItemCount() {
        int photosCount;
        int n = photosCount = this.photoDirectories.size() == 0 ? 0 : this.getCurrentPhotos().size();
        if (this.showCamera()) {
            return photosCount + 1;
        }
        return photosCount;
    }

    public void setOnItemCheckListener(OnItemCheckListener onItemCheckListener) {
        this.onItemCheckListener = onItemCheckListener;
    }

    public void setOnPhotoClickListener(OnPhotoClickListener onPhotoClickListener) {
        this.onPhotoClickListener = onPhotoClickListener;
    }

    public void setOnCameraClickListener(View.OnClickListener onCameraClickListener) {
        this.onCameraClickListener = onCameraClickListener;
    }

    public ArrayList<String> getSelectedPhotoPaths() {
        ArrayList<String> selectedPhotoPaths = new ArrayList<String>(this.getSelectedItemCount());
        for (String photo : this.selectedPhotos) {
            selectedPhotoPaths.add(photo);
        }
        return selectedPhotoPaths;
    }

    public void setShowCamera(boolean hasCamera) {
        this.hasCamera = hasCamera;
    }

    public void setPreviewEnable(boolean previewEnable) {
        this.previewEnable = previewEnable;
    }

    public boolean showCamera() {
        return this.hasCamera && this.currentDirectoryIndex == 0;
    }

    public void onViewRecycled(PhotoViewHolder holder) {
        Glide.clear((View)holder.ivPhoto);
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
    }

    public static class PhotoViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView ivPhoto;
        private View vSelected;

        public PhotoViewHolder(View itemView) {
            super(itemView);
            this.ivPhoto = (ImageView)itemView.findViewById(R.id.iv_photo);
            this.vSelected = itemView.findViewById(R.id.v_selected);
        }
    }
}

