/*
 * Decompiled with CFR 0.152.
 */
package me.iwf.photopicker;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.List;
import me.iwf.photopicker.R;
import me.iwf.photopicker.entity.Photo;
import me.iwf.photopicker.event.OnItemCheckListener;
import me.iwf.photopicker.fragment.ImagePagerFragment;
import me.iwf.photopicker.fragment.PhotoPickerFragment;

public class PhotoPickerActivity
extends AppCompatActivity {
    private PhotoPickerFragment pickerFragment;
    private ImagePagerFragment imagePagerFragment;
    private MenuItem menuDoneItem;
    private int maxCount = 9;
    private boolean menuIsInflated = false;
    private boolean showGif = false;
    private int columnNumber = 3;
    private ArrayList<String> originalPhotos = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        boolean showCamera = this.getIntent().getBooleanExtra("SHOW_CAMERA", true);
        boolean showGif = this.getIntent().getBooleanExtra("SHOW_GIF", false);
        boolean previewEnabled = this.getIntent().getBooleanExtra("PREVIEW_ENABLED", true);
        this.setShowGif(showGif);
        this.setContentView(R.layout.__picker_activity_photo_picker);
        Toolbar mToolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(mToolbar);
        this.setTitle(R.string.__picker_title);
        ActionBar actionBar = this.getSupportActionBar();
        assert (actionBar != null);
        actionBar.setDisplayHomeAsUpEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) {
            actionBar.setElevation(25.0f);
        }
        this.maxCount = this.getIntent().getIntExtra("MAX_COUNT", 9);
        this.columnNumber = this.getIntent().getIntExtra("column", 3);
        this.originalPhotos = this.getIntent().getStringArrayListExtra("ORIGINAL_PHOTOS");
        this.pickerFragment = (PhotoPickerFragment)this.getSupportFragmentManager().findFragmentByTag("tag");
        if (this.pickerFragment == null) {
            this.pickerFragment = PhotoPickerFragment.newInstance(showCamera, showGif, previewEnabled, this.columnNumber, this.maxCount, this.originalPhotos);
            this.getSupportFragmentManager().beginTransaction().replace(R.id.container, (Fragment)this.pickerFragment, "tag").commit();
            this.getSupportFragmentManager().executePendingTransactions();
        }
        this.pickerFragment.getPhotoGridAdapter().setOnItemCheckListener(new OnItemCheckListener(){

            @Override
            public boolean OnItemCheck(int position, Photo photo, boolean isCheck, int selectedItemCount) {
                int total = selectedItemCount + (isCheck ? -1 : 1);
                PhotoPickerActivity.this.menuDoneItem.setEnabled(total > 0);
                if (PhotoPickerActivity.this.maxCount <= 1) {
                    List<String> photos = PhotoPickerActivity.this.pickerFragment.getPhotoGridAdapter().getSelectedPhotos();
                    if (!photos.contains(photo.getPath())) {
                        photos.clear();
                        PhotoPickerActivity.this.pickerFragment.getPhotoGridAdapter().notifyDataSetChanged();
                    }
                    return true;
                }
                if (total > PhotoPickerActivity.this.maxCount) {
                    Toast.makeText((Context)PhotoPickerActivity.this.getActivity(), (CharSequence)PhotoPickerActivity.this.getString(R.string.__picker_over_max_count_tips, new Object[]{PhotoPickerActivity.this.maxCount}), (int)1).show();
                    return false;
                }
                PhotoPickerActivity.this.menuDoneItem.setTitle((CharSequence)PhotoPickerActivity.this.getString(R.string.__picker_done_with_count, new Object[]{total, PhotoPickerActivity.this.maxCount}));
                return true;
            }
        });
    }

    public void onBackPressed() {
        if (this.imagePagerFragment != null && this.imagePagerFragment.isVisible()) {
            this.imagePagerFragment.runExitAnimation(new Runnable(){

                @Override
                public void run() {
                    if (PhotoPickerActivity.this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
                        PhotoPickerActivity.this.getSupportFragmentManager().popBackStack();
                    }
                }
            });
        } else {
            super.onBackPressed();
        }
    }

    public void addImagePagerFragment(ImagePagerFragment imagePagerFragment) {
        this.imagePagerFragment = imagePagerFragment;
        this.getSupportFragmentManager().beginTransaction().replace(R.id.container, (Fragment)this.imagePagerFragment).addToBackStack(null).commit();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        if (!this.menuIsInflated) {
            this.getMenuInflater().inflate(R.menu.__picker_menu_picker, menu2);
            this.menuDoneItem = menu2.findItem(R.id.done);
            if (this.originalPhotos != null && this.originalPhotos.size() > 0) {
                this.menuDoneItem.setEnabled(true);
                this.menuDoneItem.setTitle((CharSequence)this.getString(R.string.__picker_done_with_count, new Object[]{this.originalPhotos.size(), this.maxCount}));
            } else {
                this.menuDoneItem.setEnabled(false);
            }
            this.menuIsInflated = true;
            return true;
        }
        return false;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            super.onBackPressed();
            return true;
        }
        if (item.getItemId() == R.id.done) {
            Intent intent = new Intent();
            ArrayList<String> selectedPhotos = this.pickerFragment.getPhotoGridAdapter().getSelectedPhotoPaths();
            intent.putStringArrayListExtra("SELECTED_PHOTOS", selectedPhotos);
            this.setResult(-1, intent);
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public PhotoPickerActivity getActivity() {
        return this;
    }

    public boolean isShowGif() {
        return this.showGif;
    }

    public void setShowGif(boolean showGif) {
        this.showGif = showGif;
    }
}

