/*
 * Decompiled with CFR 0.152.
 */
package me.iwf.photopicker;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.design.widget.Snackbar;
import android.support.v4.view.ViewPager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import java.util.ArrayList;
import me.iwf.photopicker.R;
import me.iwf.photopicker.fragment.ImagePagerFragment;

public class PhotoPagerActivity
extends AppCompatActivity {
    private ImagePagerFragment pagerFragment;
    private ActionBar actionBar;
    private boolean showDelete;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.__picker_activity_photo_pager);
        int currentItem = this.getIntent().getIntExtra("current_item", 0);
        ArrayList paths = this.getIntent().getStringArrayListExtra("photos");
        this.showDelete = this.getIntent().getBooleanExtra("show_delete", true);
        if (this.pagerFragment == null) {
            this.pagerFragment = (ImagePagerFragment)this.getSupportFragmentManager().findFragmentById(R.id.photoPagerFragment);
        }
        this.pagerFragment.setPhotos(paths, currentItem);
        Toolbar mToolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(mToolbar);
        this.actionBar = this.getSupportActionBar();
        if (this.actionBar != null) {
            this.actionBar.setDisplayHomeAsUpEnabled(true);
            this.updateActionBarTitle();
            if (Build.VERSION.SDK_INT >= 21) {
                this.actionBar.setElevation(25.0f);
            }
        }
        this.pagerFragment.getViewPager().addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                PhotoPagerActivity.this.updateActionBarTitle();
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        if (this.showDelete) {
            this.getMenuInflater().inflate(R.menu.__picker_menu_preview, menu2);
        }
        return true;
    }

    public void onBackPressed() {
        Intent intent = new Intent();
        intent.putExtra("SELECTED_PHOTOS", this.pagerFragment.getPaths());
        this.setResult(-1, intent);
        this.finish();
        super.onBackPressed();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        if (item.getItemId() == R.id.delete) {
            final int index = this.pagerFragment.getCurrentItem();
            final String deletedPath = this.pagerFragment.getPaths().get(index);
            Snackbar snackbar = Snackbar.make((View)this.pagerFragment.getView(), (int)R.string.__picker_deleted_a_photo, (int)0);
            if (this.pagerFragment.getPaths().size() <= 1) {
                new AlertDialog.Builder((Context)this).setTitle(R.string.__picker_confirm_to_delete).setPositiveButton(R.string.__picker_yes, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        dialogInterface.dismiss();
                        PhotoPagerActivity.this.pagerFragment.getPaths().remove(index);
                        PhotoPagerActivity.this.pagerFragment.getViewPager().getAdapter().notifyDataSetChanged();
                        PhotoPagerActivity.this.onBackPressed();
                    }
                }).setNegativeButton(R.string.__picker_cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        dialogInterface.dismiss();
                    }
                }).show();
            } else {
                snackbar.show();
                this.pagerFragment.getPaths().remove(index);
                this.pagerFragment.getViewPager().getAdapter().notifyDataSetChanged();
            }
            snackbar.setAction(R.string.__picker_undo, new View.OnClickListener(){

                public void onClick(View view) {
                    if (PhotoPagerActivity.this.pagerFragment.getPaths().size() > 0) {
                        PhotoPagerActivity.this.pagerFragment.getPaths().add(index, deletedPath);
                    } else {
                        PhotoPagerActivity.this.pagerFragment.getPaths().add(deletedPath);
                    }
                    PhotoPagerActivity.this.pagerFragment.getViewPager().getAdapter().notifyDataSetChanged();
                    PhotoPagerActivity.this.pagerFragment.getViewPager().setCurrentItem(index, true);
                }
            });
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void updateActionBarTitle() {
        if (this.actionBar != null) {
            this.actionBar.setTitle((CharSequence)this.getString(R.string.__picker_image_index, new Object[]{this.pagerFragment.getViewPager().getCurrentItem() + 1, this.pagerFragment.getPaths().size()}));
        }
    }
}

