/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.session.redis;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import me.hao0.session.api.SessionIdGenerator;
import me.hao0.session.core.AbstractSessionManager;
import me.hao0.session.exception.SessionException;
import me.hao0.session.redis.RedisCallback;
import me.hao0.session.redis.RedisExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;

public class RedisSessionManager
extends AbstractSessionManager {
    private static final Logger log = LoggerFactory.getLogger(RedisSessionManager.class);
    private static final String SENTINEL_MODE = "sentinel";
    private String sessionPrefix;
    private volatile RedisExecutor executor;

    public RedisSessionManager() throws IOException {
    }

    public RedisSessionManager(String propertiesFile) throws IOException {
        super(propertiesFile);
    }

    protected void init(Properties props) {
        this.sessionPrefix = props.getProperty("session.redis.prefix", "rsession");
        this.initJedisPool(props);
    }

    private void initJedisPool(Properties props) {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setTestOnBorrow(true);
        Integer maxIdle = Integer.parseInt(props.getProperty("session.redis.pool.max.idle", "2"));
        config.setMaxIdle(maxIdle.intValue());
        Integer maxTotal = Integer.parseInt(props.getProperty("session.redis.pool.max.total", "5"));
        config.setMaxTotal(maxTotal.intValue());
        String mode = props.getProperty("session.redis.mode");
        this.executor = Objects.equal((Object)mode, (Object)SENTINEL_MODE) ? new RedisExecutor(config, true, props) : new RedisExecutor(config, false, props);
    }

    public Boolean persist(String id, final Map<String, Object> snapshot, final int maxInactiveInterval) {
        final String sid = this.sessionPrefix + ":" + id;
        try {
            this.executor.execute(new RedisCallback<Void>(){

                @Override
                public Void execute(Jedis jedis) {
                    if (snapshot.isEmpty()) {
                        jedis.del(sid);
                    } else {
                        jedis.setex(sid, maxInactiveInterval, RedisSessionManager.this.serializer.serialize((Object)snapshot));
                    }
                    return null;
                }
            });
            return Boolean.TRUE;
        }
        catch (Exception e) {
            log.error("failed to persist session(id={}, snapshot={}), cause:{}", new Object[]{sid, snapshot, Throwables.getStackTraceAsString((Throwable)e)});
            return Boolean.FALSE;
        }
    }

    public Map<String, Object> loadById(String id) {
        final String sid = this.sessionPrefix + ":" + id;
        try {
            return this.executor.execute(new RedisCallback<Map<String, Object>>(){

                @Override
                public Map<String, Object> execute(Jedis jedis) {
                    String session = jedis.get(sid);
                    if (!Strings.isNullOrEmpty((String)session)) {
                        return RedisSessionManager.this.serializer.deserialize(session);
                    }
                    return Collections.emptyMap();
                }
            });
        }
        catch (Exception e) {
            log.error("failed to load session(key={}), cause:{}", (Object)sid, (Object)Throwables.getStackTraceAsString((Throwable)e));
            throw new SessionException("load session failed", (Throwable)e);
        }
    }

    public void deleteById(String id) {
        final String sid = this.sessionPrefix + ":" + id;
        try {
            this.executor.execute(new RedisCallback<Void>(){

                @Override
                public Void execute(Jedis jedis) {
                    jedis.del(sid);
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error("failed to delete session(key={}) in redis,cause:{}", (Object)sid, (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public void expire(String sid, final int maxInactiveInterval) {
        final String sessionId = this.sessionPrefix + ":" + sid;
        try {
            this.executor.execute(new RedisCallback<Void>(){

                @Override
                public Void execute(Jedis jedis) {
                    jedis.expire(sessionId, maxInactiveInterval);
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error("failed to refresh expire time session(key={}) in redis,cause:{}", (Object)sessionId, (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public void destroy() {
        if (this.executor != null) {
            this.executor.getJedisPool().destroy();
        }
    }

    public SessionIdGenerator getSessionIdGenerator() {
        return this.sessionIdGenerator;
    }
}

