/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.session.redis;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import me.hao0.session.redis.RedisCallback;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.util.Pool;

public class RedisExecutor {
    private volatile Pool<Jedis> jedisPool;

    public RedisExecutor(JedisPoolConfig config, boolean sentinel, Properties props) {
        if (sentinel) {
            String sentinelProps = props.getProperty("session.redis.sentinel.hosts");
            Iterable hosts = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)sentinelProps);
            HashSet sentinelHosts = Sets.newHashSet((Iterable)hosts);
            String masterName = props.getProperty("session.redis.sentinel.master.name");
            this.jedisPool = new JedisSentinelPool(masterName, (Set)sentinelHosts, (GenericObjectPoolConfig)config);
        } else {
            String redisHost = props.getProperty("session.redis.host");
            int redisPort = Integer.parseInt(props.getProperty("session.redis.port"));
            this.jedisPool = new JedisPool((GenericObjectPoolConfig)config, redisHost, redisPort);
        }
    }

    public <V> V execute(RedisCallback<V> cb) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        boolean success = true;
        try {
            V v = cb.execute(jedis);
            return v;
        }
        catch (JedisException e) {
            success = false;
            if (jedis != null) {
                this.jedisPool.returnBrokenResource((Object)jedis);
            }
            throw e;
        }
        finally {
            if (success) {
                this.jedisPool.returnResource((Object)jedis);
            }
        }
    }

    public Pool<Jedis> getJedisPool() {
        return this.jedisPool;
    }
}

