/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.session.util;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebUtil {
    private static final Logger log = LoggerFactory.getLogger(WebUtil.class);
    private static final String[] HEADERS_ABOUT_CLIENT_IP = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR"};
    private static final String[] AGENT_INDEX = new String[]{"MSIE", "Firefox", "Chrome", "Opera", "Safari"};
    private static final Map<String, Pattern> AGENT_PATTERNS = ImmutableMap.of((Object)AGENT_INDEX[0], (Object)Pattern.compile("MSIE ([\\d.]+)"), (Object)AGENT_INDEX[1], (Object)Pattern.compile("Firefox/(\\d.+)"), (Object)AGENT_INDEX[2], (Object)Pattern.compile("Chrome/([\\d.]+)"), (Object)AGENT_INDEX[3], (Object)Pattern.compile("Opera[/\\s]([\\d.]+)"), (Object)AGENT_INDEX[4], (Object)Pattern.compile("Version/([\\d.]+)"));

    private WebUtil() {
    }

    public static String getClientIpAddr(HttpServletRequest request) {
        for (String header : HEADERS_ABOUT_CLIENT_IP) {
            String ip = request.getHeader(header);
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) continue;
            return ip;
        }
        return request.getRemoteAddr();
    }

    public static Cookie findCookie(HttpServletRequest request, String name) {
        Cookie[] cookies;
        if (request != null && (cookies = request.getCookies()) != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static String findCookieValue(HttpServletRequest request, String name) {
        Cookie cookie = WebUtil.findCookie(request, name);
        return cookie != null ? cookie.getValue() : null;
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxAge) {
        WebUtil.addCookie(request, response, name, value, null, maxAge, false);
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, String domain, int maxAge, boolean httpOnly) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.isEmpty()) {
            contextPath = "/";
        }
        WebUtil.addCookie(request, response, name, value, domain, contextPath, maxAge, httpOnly);
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, String domain, String contextPath, int maxAge, boolean httpOnly) {
        if (request != null && response != null) {
            Cookie cookie = new Cookie(name, value);
            cookie.setMaxAge(maxAge);
            cookie.setSecure(request.isSecure());
            if (contextPath == null || contextPath.isEmpty()) {
                cookie.setPath("/");
            } else {
                cookie.setPath(contextPath);
            }
            if (domain != null && !domain.isEmpty()) {
                cookie.setDomain(domain);
            }
            if (httpOnly) {
                cookie.setHttpOnly(true);
            }
            response.addCookie(cookie);
            log.debug("Cookie update the sessionID.[name={},value={},maxAge={},httpOnly={},path={},domain={}]", new Object[]{cookie.getName(), cookie.getValue(), cookie.getMaxAge(), httpOnly, cookie.getPath(), cookie.getDomain()});
        }
    }

    public static void failureCookie(HttpServletRequest request, HttpServletResponse response, String name, String domain, String contextPath) {
        if (request != null && response != null) {
            WebUtil.addCookie(request, response, name, null, domain, contextPath, 0, true);
        }
    }

    public static void failureCookie(HttpServletRequest request, HttpServletResponse response, String name, String domain) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.isEmpty()) {
            contextPath = "/";
        }
        WebUtil.failureCookie(request, response, name, domain, contextPath);
    }

    public static void failureCookie(HttpServletRequest request, HttpServletResponse response, String name) {
        WebUtil.failureCookie(request, response, name, null);
    }

    public static String getFullRequestUrl(HttpServletRequest request) {
        StringBuilder buff = new StringBuilder(request.getRequestURL().toString());
        String queryString = request.getQueryString();
        if (queryString != null) {
            buff.append("?").append(queryString);
        }
        return buff.toString();
    }

    public static void redirect(HttpServletResponse response, String url, boolean movePermanently) throws IOException {
        if (!movePermanently) {
            response.sendRedirect(url);
        } else {
            response.setStatus(301);
            response.setHeader("Location", url);
        }
    }

    public static UserAgent getUserAgent(String userAgent) {
        if (userAgent == null || userAgent.isEmpty()) {
            return null;
        }
        for (String aAGENT_INDEX : AGENT_INDEX) {
            Pattern pattern = AGENT_PATTERNS.get(aAGENT_INDEX);
            Matcher matcher = pattern.matcher(userAgent);
            if (!matcher.find()) continue;
            return new UserAgent(aAGENT_INDEX, matcher.group(1));
        }
        return null;
    }

    public static UserAgent getUserAgent(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String userAgentHead = request.getHeader("User-Agent");
        return WebUtil.getUserAgent(userAgentHead);
    }

    public static class UserAgent {
        private String name = "";
        private String version = "";

        public UserAgent(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

