/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.session.core;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.hao0.session.api.SessionManager;
import me.hao0.session.core.HttpServletRequest2;
import me.hao0.session.core.HttpSession2;
import me.hao0.session.util.WebUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SessionFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SessionFilter.class);
    protected static final String SESSION_COOKIE_NAME = "sessionCookieName";
    protected static final String DEFAULT_SESSION_COOKIE_NAME = "sfid";
    protected String sessionCookieName;
    protected static final String MAX_INACTIVE_INTERVAL = "maxInactiveInterval";
    protected static final int DEFAULT_MAX_INACTIVE_INTERVAL = 1800;
    protected int maxInactiveInterval;
    protected static final String COOKIE_DOMAIN = "cookieDomain";
    protected String cookieDomain;
    protected static final String COOKIE_CONTEXT_PATH = "cookieContextPath";
    protected static final String DEFAULT_COOKIE_CONTEXT_PATH = "/";
    protected String cookieContextPath;
    protected static final String COOKIE_MAX_AGE = "cookieMaxAge";
    protected static final int DEFAULT_COOKIE_MAX_AGE = -1;
    protected int cookieMaxAge;
    protected SessionManager sessionManager;

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.sessionManager = this.createSessionManager();
            this.initAttrs(filterConfig);
        }
        catch (Exception ex) {
            log.error("failed to init session filter.", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
    }

    protected abstract SessionManager createSessionManager() throws IOException;

    private void initAttrs(FilterConfig config) {
        String param = config.getInitParameter(SESSION_COOKIE_NAME);
        this.sessionCookieName = Strings.isNullOrEmpty((String)param) ? DEFAULT_SESSION_COOKIE_NAME : param;
        param = config.getInitParameter(MAX_INACTIVE_INTERVAL);
        this.maxInactiveInterval = Strings.isNullOrEmpty((String)param) ? 1800 : Integer.parseInt(param);
        this.cookieDomain = config.getInitParameter(COOKIE_DOMAIN);
        param = config.getInitParameter(COOKIE_CONTEXT_PATH);
        this.cookieContextPath = Strings.isNullOrEmpty((String)param) ? DEFAULT_COOKIE_CONTEXT_PATH : param;
        param = config.getInitParameter(COOKIE_MAX_AGE);
        this.cookieMaxAge = Strings.isNullOrEmpty((String)param) ? -1 : Integer.parseInt(param);
        log.info("SessionFilter (sessionCookieName={},maxInactiveInterval={},cookieDomain={})", new Object[]{this.sessionCookieName, this.maxInactiveInterval, this.cookieDomain});
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest2) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpServletRequest2 request2 = new HttpServletRequest2(httpRequest, httpResponse, this.sessionManager);
        request2.setSessionCookieName(this.sessionCookieName);
        request2.setMaxInactiveInterval(this.maxInactiveInterval);
        request2.setCookieDomain(this.cookieDomain);
        request2.setCookieContextPath(this.cookieContextPath);
        request2.setCookieMaxAge(this.cookieMaxAge);
        chain.doFilter((ServletRequest)request2, response);
        HttpSession2 session = request2.currentSession();
        if (session != null) {
            if (!session.isValid()) {
                log.debug("session is invalid, will delete.");
                WebUtil.failureCookie(httpRequest, httpResponse, this.sessionCookieName, this.cookieDomain, this.cookieContextPath);
            } else if (session.isDirty()) {
                log.debug("try to flush session to session store");
                Map<String, Object> snapshot = session.snapshot();
                if (this.sessionManager.persist(session.getId(), snapshot, this.maxInactiveInterval).booleanValue()) {
                    log.debug("succeed to flush session {} to store, key is:{}", snapshot, (Object)session.getId());
                } else {
                    log.error("failed to persist session to redis");
                    WebUtil.failureCookie(httpRequest, httpResponse, this.sessionCookieName, this.cookieDomain, this.cookieContextPath);
                }
            } else {
                this.sessionManager.expire(session.getId(), this.maxInactiveInterval);
            }
        }
    }

    public void destroy() {
        this.sessionManager.destroy();
        log.debug("filter is destroy.");
    }
}

