/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.session.core;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.base.Throwables;
import java.util.Map;
import me.hao0.common.json.Jsons;
import me.hao0.session.api.Serializer;
import me.hao0.session.exception.SerializeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonSerializer
implements Serializer {
    private static final Logger log = LoggerFactory.getLogger(JsonSerializer.class);
    private static final JavaType MAP_TYPE = Jsons.DEFAULT.createCollectionType(Map.class, new Class[]{String.class, Object.class});

    @Override
    public String serialize(Object o) {
        try {
            return Jsons.DEFAULT.toJson(o);
        }
        catch (Exception e) {
            log.error("failed to serialize http session {} to json,cause:{}", o, (Object)Throwables.getStackTraceAsString((Throwable)e));
            throw new SerializeException("failed to serialize http session to json", e);
        }
    }

    @Override
    public Map<String, Object> deserialize(String o) {
        try {
            return (Map)Jsons.DEFAULT.fromJson(o, MAP_TYPE);
        }
        catch (Exception e) {
            log.error("failed to deserialize string  {} to http session,cause:{} ", (Object)o, (Object)Throwables.getStackTraceAsString((Throwable)e));
            throw new SerializeException("failed to deserialize string to http session", e);
        }
    }
}

