/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.session.core;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import me.hao0.session.api.SessionManager;
import me.hao0.session.core.HttpSession2;
import me.hao0.session.util.WebUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletRequest2
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(HttpServletRequest2.class);
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final SessionManager sessionManager;
    private HttpSession2 session;
    private String sessionCookieName;
    private String cookieDomain;
    private String cookieContextPath;
    private int maxInactiveInterval;
    private int cookieMaxAge;

    public HttpServletRequest2(HttpServletRequest request, HttpServletResponse response, SessionManager sessionManager) {
        super(request);
        this.request = request;
        this.response = response;
        this.sessionManager = sessionManager;
    }

    public HttpSession getSession(boolean create) {
        return this.doGetSession(create);
    }

    public HttpSession getSession() {
        return this.doGetSession(true);
    }

    public String getSessionCookieName() {
        return this.sessionCookieName;
    }

    public void setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public String getCookieContextPath() {
        return this.cookieContextPath;
    }

    public void setCookieContextPath(String cookieContextPath) {
        this.cookieContextPath = cookieContextPath;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public void setCookieMaxAge(int cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    public HttpSession2 currentSession() {
        return this.session;
    }

    private HttpSession doGetSession(boolean create) {
        if (this.session == null) {
            Cookie cookie = WebUtil.findCookie((HttpServletRequest)this, this.getSessionCookieName());
            if (cookie != null) {
                String value = cookie.getValue();
                log.debug("discovery session id from cookie: {}", (Object)value);
                this.session = this.buildSession(value, false);
            } else {
                this.session = this.buildSession(create);
            }
        } else {
            log.debug("Session[{}] was existed.", (Object)this.session.getId());
        }
        return this.session;
    }

    private HttpSession2 buildSession(String id, boolean refresh) {
        HttpSession2 session = new HttpSession2(id, this.sessionManager, this.request.getServletContext());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        if (refresh) {
            WebUtil.addCookie((HttpServletRequest)this, this.response, this.getSessionCookieName(), id, this.getCookieDomain(), this.getCookieContextPath(), this.cookieMaxAge, true);
        }
        return session;
    }

    private HttpSession2 buildSession(boolean create) {
        if (create) {
            this.session = this.buildSession(this.sessionManager.getSessionIdGenerator().generate(this.request), true);
            log.debug("Build new session[{}].", (Object)this.session.getId());
            return this.session;
        }
        return null;
    }
}

