/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.session.core;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Properties;
import me.hao0.session.api.Serializer;
import me.hao0.session.api.SessionIdGenerator;
import me.hao0.session.api.SessionManager;
import me.hao0.session.core.DefaultSessionIdGenerator;
import me.hao0.session.core.JsonSerializer;
import me.hao0.session.util.PropertiesReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSessionManager
implements SessionManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractSessionManager.class);
    private static final String DEFAULT_PROPERTIES = "session.properties";
    protected SessionIdGenerator sessionIdGenerator;
    protected Serializer serializer;

    public AbstractSessionManager() throws IOException {
        this(DEFAULT_PROPERTIES);
    }

    public AbstractSessionManager(String propertiesFile) throws IOException {
        Properties props = PropertiesReader.read(propertiesFile);
        this.initSessionIdGenerator(props);
        this.initSerializer(props);
        this.init(props);
    }

    protected void init(Properties props) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSerializer(Properties props) {
        String sessionSerializer = (String)props.get("session.serializer");
        if (Strings.isNullOrEmpty((String)sessionSerializer)) {
            this.serializer = new JsonSerializer();
        } else {
            try {
                this.serializer = (Serializer)Class.forName(sessionSerializer).newInstance();
            }
            catch (Exception e) {
                log.error("failed to init json generator: {}", (Object)Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                if (this.sessionIdGenerator == null) {
                    log.info("use default json serializer [JsonSerializer]");
                    this.serializer = new JsonSerializer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSessionIdGenerator(Properties props) {
        String sessionIdGeneratorClazz = (String)props.get("session.id.generator");
        if (Strings.isNullOrEmpty((String)sessionIdGeneratorClazz)) {
            this.sessionIdGenerator = new DefaultSessionIdGenerator();
        } else {
            try {
                this.sessionIdGenerator = (SessionIdGenerator)Class.forName(sessionIdGeneratorClazz).newInstance();
            }
            catch (Exception e) {
                log.error("failed to init session id generator: {}", (Object)Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                if (this.sessionIdGenerator == null) {
                    log.info("use default session id generator[DefaultSessionIdGenerator]");
                    this.sessionIdGenerator = new DefaultSessionIdGenerator();
                }
            }
        }
    }
}

