/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.common.security;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import me.hao0.common.exception.SecurityException;
import me.hao0.common.security.Base64;

public class RSA {
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA1WithRSA";
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";
    private static final Integer KEY_SIZE = 1024;

    public static Map<String, Object> initKey() {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            keyPairGen.initialize(KEY_SIZE);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            HashMap<String, Object> keyMap = new HashMap<String, Object>(2);
            keyMap.put(PUBLIC_KEY, publicKey);
            keyMap.put(PRIVATE_KEY, privateKey);
            return keyMap;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
    }

    public static String sign(String signing, String privateKey, String charset) {
        try {
            return RSA.sign(signing.getBytes(charset), privateKey);
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e);
        }
    }

    public static String sign(byte[] data, String privateKey) {
        try {
            byte[] keyBytes = RSA.base64Decode(privateKey);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initSign(priKey);
            signature.update(data);
            return RSA.base64Encode(signature.sign());
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static boolean verify(String signing, String signed, String publicKey, String charset) {
        try {
            return RSA.verify(signing.getBytes(charset), signed, publicKey);
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e);
        }
    }

    public static boolean verify(byte[] data, String signed, String publicKey) {
        try {
            byte[] keyBytes = RSA.base64Decode(publicKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PublicKey pubKey = keyFactory.generatePublic(keySpec);
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initVerify(pubKey);
            signature.update(data);
            return signature.verify(RSA.base64Decode(signed));
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static byte[] decryptByPrivateKey(byte[] data, String key) {
        try {
            byte[] keyBytes = RSA.base64Decode(key);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, privateKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static byte[] decryptByPublicKey(byte[] data, String key) {
        try {
            byte[] keyBytes = RSA.base64Decode(key);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, publicKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static byte[] encryptByPublicKey(byte[] data, String key) {
        try {
            byte[] keyBytes = RSA.base64Decode(key);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, publicKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static byte[] encryptByPrivateKey(byte[] data, String key) {
        try {
            byte[] keyBytes = RSA.base64Decode(key);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, privateKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static String getPrivateKey(Map<String, Object> keyMap) {
        Key key = (Key)keyMap.get(PRIVATE_KEY);
        return RSA.base64Encode(key.getEncoded());
    }

    public static String getPublicKey(Map<String, Object> keyMap) {
        Key key = (Key)keyMap.get(PUBLIC_KEY);
        return RSA.base64Encode(key.getEncoded());
    }

    public static String base64Encode(byte[] key) {
        return Base64.encode(key);
    }

    public static byte[] base64Decode(String key) {
        return Base64.decode(key);
    }
}

