/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.common.http;

import com.fasterxml.jackson.databind.JavaType;
import com.github.kevinsawicki.http.HttpRequest;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import me.hao0.common.exception.HttpException;
import me.hao0.common.http.HttpMethod;
import me.hao0.common.json.Jsons;
import me.hao0.common.util.Strings;

public class Http {
    private String url;
    private HttpMethod method = HttpMethod.GET;
    private Map<String, String> headers = Collections.emptyMap();
    private Map<String, ?> params = Collections.emptyMap();
    private String body;
    private Boolean ssl = Boolean.FALSE;
    private Integer connectTimeout = 5000;
    private Integer readTimeout = 5000;
    private Boolean encode = Boolean.TRUE;
    private String contentType = "";
    private String charset = "UTF-8";
    private String accept = "";

    private Http(String url) {
        this.url = url;
    }

    private Http method(HttpMethod method) {
        this.method = method;
        return this;
    }

    public Http ssl() {
        this.ssl = Boolean.TRUE;
        return this;
    }

    public Http headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Http params(Map<String, ?> params) {
        this.params = params;
        return this;
    }

    public Http body(String body) {
        this.body = body;
        return this;
    }

    public Http encode(Boolean encode) {
        this.encode = encode;
        return this;
    }

    public Http contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Http charset(String charset) {
        this.charset = charset;
        return this;
    }

    public Http accept(String accept) {
        this.accept = accept;
        return this;
    }

    public Http connTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout * 1000;
        return this;
    }

    public Http readTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout * 1000;
        return this;
    }

    public String request() {
        switch (this.method) {
            case GET: {
                return this.doGet();
            }
            case POST: {
                return this.doPost();
            }
        }
        return null;
    }

    public <T> T request(JavaType type) {
        return Jsons.DEFAULT.fromJson(this.request(), type);
    }

    private String doPost() {
        HttpRequest post = HttpRequest.post((CharSequence)this.url, this.params, (boolean)this.encode).headers(this.headers).connectTimeout(this.connectTimeout.intValue()).readTimeout(this.readTimeout.intValue()).acceptGzipEncoding().uncompress(true);
        this.setOptionalHeaders(post);
        if (!Strings.isNullOrEmpty(this.body).booleanValue()) {
            post.send((CharSequence)this.body);
        }
        if (this.ssl.booleanValue()) {
            this.trustHttps(post);
        }
        return post.body();
    }

    private String doGet() {
        HttpRequest get = HttpRequest.get((CharSequence)this.url, this.params, (boolean)this.encode).headers(this.headers).connectTimeout(this.connectTimeout.intValue()).readTimeout(this.readTimeout.intValue()).acceptGzipEncoding().uncompress(true);
        if (this.ssl.booleanValue()) {
            this.trustHttps(get);
        }
        this.setOptionalHeaders(get);
        return get.body();
    }

    private void setOptionalHeaders(HttpRequest request) {
        if (!Strings.isNullOrEmpty(this.contentType).booleanValue()) {
            request.contentType(this.contentType, this.charset);
        }
        if (!Strings.isNullOrEmpty(this.accept).booleanValue()) {
            request.accept(this.accept);
        }
    }

    private void trustHttps(HttpRequest request) {
        request.trustAllCerts().trustAllHosts();
    }

    public static Http get(String url) {
        return new Http(url);
    }

    public static Http post(String url) {
        return new Http(url).method(HttpMethod.POST);
    }

    public static Http put(String url) {
        return new Http(url).method(HttpMethod.PUT);
    }

    public static Http delete(String url) {
        return new Http(url).method(HttpMethod.DELETE);
    }

    public static String upload(String url, String fieldName, String fileName, byte[] data, Map<String, String> params) {
        return Http.upload(url, fieldName, fileName, new ByteArrayInputStream(data), params);
    }

    public static String upload(String url, String fieldName, String fileName, InputStream in, Map<String, String> params) {
        try {
            HttpRequest request = HttpRequest.post((CharSequence)url);
            if (!params.isEmpty()) {
                for (Map.Entry<String, String> param : params.entrySet()) {
                    request.part(param.getKey(), param.getValue());
                }
            }
            request.part(fieldName, fileName, null, in);
            return request.body();
        }
        catch (Exception e) {
            throw new HttpException(e);
        }
    }

    public static void download(String url, File into) {
        try {
            Http.download(url, new FileOutputStream(into));
        }
        catch (FileNotFoundException e) {
            throw new HttpException(e);
        }
    }

    public static void download(String url, OutputStream output) {
        try {
            HttpRequest request = HttpRequest.get((CharSequence)url);
            if (!request.ok()) {
                throw new HttpException("request isn't ok: " + request.body());
            }
            request.receive(output);
        }
        catch (Exception e) {
            throw new HttpException(e);
        }
    }
}

