/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.common.date;

import java.util.Date;
import java.util.regex.Pattern;
import me.hao0.common.util.Strings;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

public class Dates {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static Boolean isValidDate(String date) {
        return Dates.isValidDate(date, "\\d{4}-\\d{2}-\\d{2}");
    }

    public static Boolean isValidDate(String date, String pattern) {
        return Strings.isNullOrEmpty(date) == false && Pattern.compile(pattern).matcher(date).matches();
    }

    public static Date now() {
        return new Date();
    }

    public static String now(String format) {
        return Dates.format(Dates.now(), format);
    }

    public static Date toDate(String dateStr) {
        return Dates.toDate(dateStr, DEFAULT_DATE_FORMAT);
    }

    public static Date toDate(String dateStr, String pattern) {
        return DateTimeFormat.forPattern((String)pattern).parseDateTime(dateStr).toDate();
    }

    public static Date toDate(long millis) {
        return new DateTime(millis).toDate();
    }

    public static String format(Date date, String format) {
        return new DateTime((Object)date).toString(format);
    }

    public static String format(Date date) {
        return new DateTime((Object)date).toString(DEFAULT_DATE_FORMAT);
    }

    public static String format(Long mills) {
        return new DateTime((Object)mills).toString(DEFAULT_DATE_FORMAT);
    }

    public static String format(Long mills, String pattern) {
        return new DateTime((Object)mills).toString(pattern);
    }

    public static long timeInterval(Date startTime, Date endTime) {
        long start = startTime.getTime();
        long end = endTime.getTime();
        return (end - start) / 1000L;
    }

    public static Date startOfDay(Date date) {
        return new DateTime((Object)date).withTimeAtStartOfDay().toDate();
    }

    public static Date endOfDay(Date date) {
        return new DateTime((Object)date).millisOfDay().withMaximumValue().toDate();
    }

    public static Date dayOfWeek(Integer day) {
        return new DateTime((Object)DateTime.now().toString("yyyy-MM-dd")).withDayOfWeek(day.intValue()).toDate();
    }

    public static Date dayOfMonth(Integer day) {
        return new DateTime((Object)DateTime.now().toString("yyyy-MM-dd")).withDayOfMonth(day.intValue()).toDate();
    }

    public static Date dayOfYear(Integer day) {
        return new DateTime((Object)DateTime.now().toString("yyyy-MM-dd")).withDayOfYear(day.intValue()).toDate();
    }

    public static Date addMinutes(Date date, int numOfMinutes) {
        return new DateTime((Object)date).plusMinutes(numOfMinutes).toDate();
    }

    public static Date addHours(Date date, int numOfHours) {
        return new DateTime((Object)date).plusHours(numOfHours).toDate();
    }

    public static Date addDays(Date date, int numdays) {
        return new DateTime((Object)date).plusDays(numdays).toDate();
    }

    public static Date addWeeks(Date date, int numWeeks) {
        return new DateTime((Object)date).plusWeeks(numWeeks).toDate();
    }

    public static Date addMonths(Date date, int numMonths) {
        return new DateTime((Object)date).plusMonths(numMonths).toDate();
    }

    public static Date addYears(Date date, int numYears) {
        return new DateTime((Object)date).plusYears(numYears).toDate();
    }

    public static Boolean isAfter(Date a, Date b) {
        return new DateTime((Object)a).isAfter(b.getTime());
    }

    public static Boolean isAfterNow(Date a) {
        return new DateTime((Object)a).isAfterNow();
    }

    public static Boolean isBefore(Date a, Date b) {
        return new DateTime((Object)a).isBefore(b.getTime());
    }

    public static Boolean isBefore(Date a) {
        return new DateTime((Object)a).isBeforeNow();
    }

    public static Date startDateOfMonth(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.dayOfMonth().withMinimumValue().toDate();
    }

    public static Date endDateOfMonth(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.dayOfMonth().withMaximumValue().toDate();
    }

    public static Date startDateOfWeek(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.dayOfWeek().withMinimumValue().toDate();
    }

    public static Date endDateOfWeek(Date date) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.dayOfWeek().withMaximumValue().toDate();
    }
}

