/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.ws.sdk.utils;

import eleme.openapi.ws.sdk.entity.Account;
import eleme.openapi.ws.sdk.exception.UnableConnectionException;
import eleme.openapi.ws.sdk.utils.HttpUtils;
import eleme.openapi.ws.sdk.utils.JacksonUtils;
import eleme.openapi.ws.sdk.utils.Md5Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Base64;
import java.util.HashMap;
import java.util.Properties;

public class ClientEnvUtils {
    public static String getLocalMac() {
        try {
            byte[] mac = NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress();
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < mac.length; ++i) {
                int temp;
                String str;
                if (i != 0) {
                    sb.append("-");
                }
                if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                    sb.append("0" + str);
                    continue;
                }
                sb.append(str);
            }
            return sb.toString().toUpperCase();
        }
        catch (Exception exception) {
            return "UNKONOW_MAC";
        }
    }

    public static final int getProcessID() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        System.out.println(runtimeMXBean.getName());
        return Integer.valueOf(runtimeMXBean.getName().split("@")[0]);
    }

    public static final int getThreadCount() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        System.out.println(runtimeMXBean.getName());
        return Integer.valueOf(runtimeMXBean.getName().split("@")[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static String doCommand(String command) {
        try {
            Process pro = Runtime.getRuntime().exec(command);
            pro.waitFor();
            InputStream in = pro.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            return response.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getClientProfile() {
        Properties props = System.getProperties();
        StringBuffer sb = new StringBuffer(1024);
        sb.append("osName :").append(props.getProperty("os.name")).append("\r\n");
        sb.append("osArch :").append(props.getProperty("os.arch")).append("\r\n");
        sb.append("osVersion :").append(props.getProperty("os.version")).append("\r\n");
        sb.append("javaVersion :").append(props.getProperty("java.version")).append("\r\n");
        sb.append("sdkVersion :").append("1.0.0").append("\r\n");
        sb.append("cpu cores :").append(Runtime.getRuntime().availableProcessors());
        sb.append("traceRoute :").append(ClientEnvUtils.getraceRoute());
        return sb.toString();
    }

    private static String getraceRoute() {
        Properties props = System.getProperties();
        String osName = props.getProperty("os.name");
        if (osName.toLowerCase().contains("mac")) {
            return ClientEnvUtils.doCommand("gtimeout 10 traceroute client-api.ele.me");
        }
        if (osName.toLowerCase().contains("linux")) {
            return ClientEnvUtils.doCommand("timeout 10 traceroute client-api.ele.me");
        }
        return "\u8be5\u64cd\u4f5c\u7cfb\u7edf\u4e0d\u652f\u6301traceRoute";
    }

    public static String generatorToken(Account account) {
        String token = String.format("%s#%s#%s#%s", account.getAppKey(), Md5Util.Md5(account.getAppSecret()), ClientEnvUtils.getLocalMac(), ClientEnvUtils.getProcessID());
        return Base64.getEncoder().encodeToString(token.getBytes());
    }

    public static String getWssAddress(String token) throws UnableConnectionException {
        String wssAddress;
        HashMap<String, String> contentMap = new HashMap<String, String>(3);
        contentMap.put("appId", "napos_openapi");
        contentMap.put("token", token);
        contentMap.put("routingKey", "local");
        String requestContent = JacksonUtils.obj2json(contentMap);
        HashMap<String, String> headMap = new HashMap<String, String>(2);
        headMap.put("cache-control", "no-cache");
        headMap.put("invocation-protocol", "RESTful-Protocol");
        try {
            wssAddress = HttpUtils.doPost("https://client-api.ele.me/api/line/access", "UTF-8", 3000, 3000, headMap, requestContent);
        }
        catch (IOException e) {
            throw new UnableConnectionException(e.getMessage());
        }
        return wssAddress.substring(1, wssAddress.length() - 1);
    }
}

