/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.ws.sdk.task;

import eleme.openapi.ws.sdk.config.Context;
import eleme.openapi.ws.sdk.entity.Account;
import eleme.openapi.ws.sdk.entity.HeartBeatRecord;
import eleme.openapi.ws.sdk.entity.NcpRequest;
import eleme.openapi.ws.sdk.entity.ResponsePayload;
import eleme.openapi.ws.sdk.utils.HttpUtils;
import eleme.openapi.ws.sdk.utils.JacksonUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class PullMessage {
    private static ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(2);
    public static ConcurrentHashMap<String, ArrayBlockingQueue<HeartBeatRecord>> heartBeatRecordQueueMap = new ConcurrentHashMap();
    public static Map<String, String> headerMap = new HashMap<String, String>();

    public static void startPullMessageTask() {
        executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                for (Account account : Context.accounts) {
                    try {
                        String id = UUID.randomUUID().toString();
                        headerMap.put("X-Eleme-RequestID", id);
                        String response = HttpUtils.doPost("https://open-api.shop.ele.me/invoke", headerMap, JacksonUtils.obj2json(PullMessage.wrapNcpRequest(id, account.getToken())));
                        List messages = PullMessage.resolveResponse(response);
                        if (messages == null) continue;
                        for (String message : messages) {
                            Context.elemeSdkLogger.info("pull message success :" + message);
                            Context.businessHandle.onMessage(message);
                        }
                    }
                    catch (Exception e) {
                        Context.elemeSdkLogger.error("pull message error :" + e.getMessage());
                    }
                }
            }
        }, 10L, 60 + new Random().nextInt(30), TimeUnit.SECONDS);
    }

    private static NcpRequest wrapNcpRequest(String id, String token) {
        NcpRequest request = new NcpRequest();
        request.setId(id);
        request.setNcp("2.0.0");
        request.setParams(Collections.EMPTY_MAP);
        request.setMethod("pullMessage");
        request.setService("PullMessageService");
        HashMap<String, String> metas = new HashMap<String, String>();
        metas.put("appName", "ws-sdk");
        metas.put("appVersion", "1.0.0");
        metas.put("ksid", token);
        request.setMetas(metas);
        return request;
    }

    private static List<String> resolveResponse(String response) {
        ResponsePayload ncpResponse = JacksonUtils.json2pojo(response, ResponsePayload.class);
        if (ncpResponse.getError() != null) {
            Context.elemeSdkLogger.error("pull message server error :" + ncpResponse.getError().getMessage());
            return null;
        }
        if (ncpResponse.getResult() == null) {
            return null;
        }
        return (List)ncpResponse.getResult();
    }

    static {
        headerMap.put("invocation-protocol", "Napos-Communication-Protocol-2");
        headerMap.put("Content-type", "application/json;charset=UTF-8");
        headerMap.put("Connection", "keep-alive");
    }
}

