/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.ws.sdk.config;

import eleme.openapi.ws.sdk.config.BusinessHandle;
import eleme.openapi.ws.sdk.config.Config;
import eleme.openapi.ws.sdk.config.ElemeSdkLogger;
import eleme.openapi.ws.sdk.entity.Account;
import eleme.openapi.ws.sdk.exception.UnableConnectionException;
import eleme.openapi.ws.sdk.utils.ClientEnvUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class Context {
    public static List<Account> accounts = new ArrayList<Account>();
    public static ElemeSdkLogger elemeSdkLogger;
    public static BusinessHandle businessHandle;
    public static ConcurrentHashMap<String, String> wssAddressMap;

    public static void buildStartContext(Config config) throws UnableConnectionException {
        elemeSdkLogger = config.getElemeSdkLogger();
        businessHandle = config.getBusinessHandle();
        for (Account account : config.getAccounts()) {
            String token = ClientEnvUtils.generatorToken(account);
            account.setToken(token);
            String wssAddress = ClientEnvUtils.getWssAddress(token);
            elemeSdkLogger.info("wss address:" + wssAddress);
            wssAddressMap.put(account.getAppKey(), wssAddress);
            accounts.add(account);
        }
    }

    static {
        wssAddressMap = new ConcurrentHashMap();
    }
}

