/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.chanjar.weixin.bean.WxMassNews;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WxMassNewsGsonAdapter
implements JsonSerializer<WxMassNews> {
    public JsonElement serialize(WxMassNews message, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject newsJson = new JsonObject();
        JsonArray articleJsonArray = new JsonArray();
        for (WxMassNews.WxMassNewsArticle article : message.getArticles()) {
            JsonObject articleJson = new JsonObject();
            articleJson.addProperty("thumb_media_id", article.getThumb_media_id());
            articleJson.addProperty("title", article.getTitle());
            articleJson.addProperty("content", article.getContent());
            if (null != article.getAuthor()) {
                articleJson.addProperty("author", article.getAuthor());
            }
            if (null != article.getContent_source_url()) {
                articleJson.addProperty("content_source_url", article.getContent_source_url());
            }
            if (null != article.getDigest()) {
                articleJson.addProperty("digest", article.getDigest());
            }
            articleJson.addProperty("show_cover_pic", article.isShow_cover_pic() ? "1" : "0");
            articleJsonArray.add((JsonElement)articleJson);
        }
        newsJson.add("articles", (JsonElement)articleJsonArray);
        return newsJson;
    }
}

