/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.chanjar.weixin.bean.WxGroup;
import me.chanjar.weixin.util.json.GsonHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WxGroupGsonAdapter
implements JsonSerializer<WxGroup>,
JsonDeserializer<WxGroup> {
    public JsonElement serialize(WxGroup group, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        JsonObject groupJson = new JsonObject();
        groupJson.addProperty("name", group.getName());
        groupJson.addProperty("id", (Number)group.getId());
        groupJson.addProperty("count", (Number)group.getCount());
        json.add("group", (JsonElement)groupJson);
        return json;
    }

    public WxGroup deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        WxGroup group = new WxGroup();
        JsonObject groupJson = json.getAsJsonObject();
        if (json.getAsJsonObject().get("group") != null) {
            groupJson = json.getAsJsonObject().get("group").getAsJsonObject();
        }
        if (groupJson.get("name") != null && !groupJson.get("name").isJsonNull()) {
            group.setName(GsonHelper.getAsString(groupJson.get("name")));
        }
        if (groupJson.get("id") != null && !groupJson.get("id").isJsonNull()) {
            group.setId(GsonHelper.getAsPrimitiveLong(groupJson.get("id")));
        }
        if (groupJson.get("count") != null && !groupJson.get("count").isJsonNull()) {
            group.setCount(GsonHelper.getAsPrimitiveLong(groupJson.get("count")));
        }
        return group;
    }
}

