/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.chanjar.weixin.bean.WxCustomMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WxCustomMessageGsonAdapter
implements JsonSerializer<WxCustomMessage> {
    public JsonElement serialize(WxCustomMessage message, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject messageJson = new JsonObject();
        messageJson.addProperty("touser", message.getTouser());
        messageJson.addProperty("msgtype", message.getMsgtype());
        if ("text".equals(message.getMsgtype())) {
            JsonObject text = new JsonObject();
            text.addProperty("content", message.getContent());
            messageJson.add("text", (JsonElement)text);
        }
        if ("image".equals(message.getMsgtype())) {
            JsonObject image = new JsonObject();
            image.addProperty("media_id", message.getMedia_id());
            messageJson.add("image", (JsonElement)image);
        }
        if ("voice".equals(message.getMsgtype())) {
            JsonObject voice = new JsonObject();
            voice.addProperty("media_id", message.getMedia_id());
            messageJson.add("voice", (JsonElement)voice);
        }
        if ("video".equals(message.getMsgtype())) {
            JsonObject video = new JsonObject();
            video.addProperty("media_id", message.getMedia_id());
            video.addProperty("thumb_media_id", message.getThumb_media_id());
            video.addProperty("title", message.getTitle());
            video.addProperty("description", message.getDescription());
            messageJson.add("video", (JsonElement)video);
        }
        if ("music".equals(message.getMsgtype())) {
            JsonObject music = new JsonObject();
            music.addProperty("title", message.getTitle());
            music.addProperty("description", message.getDescription());
            music.addProperty("thumb_media_id", message.getThumb_media_id());
            music.addProperty("musicurl", message.getMusicurl());
            music.addProperty("hqmusicurl", message.getHqmusicurl());
            messageJson.add("music", (JsonElement)music);
        }
        if ("news".equals(message.getMsgtype())) {
            JsonArray articleJsonArray = new JsonArray();
            for (WxCustomMessage.WxArticle article : message.getArticles()) {
                JsonObject articleJson = new JsonObject();
                articleJson.addProperty("title", article.getTitle());
                articleJson.addProperty("description", article.getDescription());
                articleJson.addProperty("url", article.getUrl());
                articleJson.addProperty("picurl", article.getPicurl());
                articleJsonArray.add((JsonElement)articleJson);
            }
            messageJson.add("articles", (JsonElement)articleJsonArray);
        }
        return messageJson;
    }
}

