/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.util.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class GsonHelper {
    public static boolean isNull(JsonElement element) {
        return element == null || element.isJsonNull();
    }

    public static boolean isNotNull(JsonElement element) {
        return !GsonHelper.isNull(element);
    }

    public static Long getLong(JsonObject json, String property) {
        return GsonHelper.getAsLong(json.get(property));
    }

    public static long getPrimitiveLong(JsonObject json, String property) {
        return GsonHelper.getAsPrimitiveLong(json.get(property));
    }

    public static Integer getInteger(JsonObject json, String property) {
        return GsonHelper.getAsInteger(json.get(property));
    }

    public static int getPrimitiveInteger(JsonObject json, String property) {
        return GsonHelper.getAsPrimitiveInt(json.get(property));
    }

    public static Double getDouble(JsonObject json, String property) {
        return GsonHelper.getAsDouble(json.get(property));
    }

    public static double getPrimitiveDouble(JsonObject json, String property) {
        return GsonHelper.getAsPrimitiveDouble(json.get(property));
    }

    public static Float getFloat(JsonObject json, String property) {
        return GsonHelper.getAsFloat(json.get(property));
    }

    public static float getPrimitiveFloat(JsonObject json, String property) {
        return GsonHelper.getAsPrimitiveFloat(json.get(property));
    }

    public static Boolean getBoolean(JsonObject json, String property) {
        return GsonHelper.getAsBoolean(json.get(property));
    }

    public static String getString(JsonObject json, String property) {
        return GsonHelper.getAsString(json.get(property));
    }

    public static String getAsString(JsonElement element) {
        return GsonHelper.isNull(element) ? null : element.getAsString();
    }

    public static Long getAsLong(JsonElement element) {
        return GsonHelper.isNull(element) ? null : Long.valueOf(element.getAsLong());
    }

    public static long getAsPrimitiveLong(JsonElement element) {
        Long r = GsonHelper.getAsLong(element);
        return r == null ? 0L : r;
    }

    public static Integer getAsInteger(JsonElement element) {
        return GsonHelper.isNull(element) ? null : Integer.valueOf(element.getAsInt());
    }

    public static int getAsPrimitiveInt(JsonElement element) {
        Integer r = GsonHelper.getAsInteger(element);
        return r == null ? 0 : r;
    }

    public static Boolean getAsBoolean(JsonElement element) {
        return GsonHelper.isNull(element) ? null : Boolean.valueOf(element.getAsBoolean());
    }

    public static boolean getAsPrimitiveBool(JsonElement element) {
        Boolean r = GsonHelper.getAsBoolean(element);
        return r == null ? false : r;
    }

    public static Double getAsDouble(JsonElement element) {
        return GsonHelper.isNull(element) ? null : Double.valueOf(element.getAsDouble());
    }

    public static double getAsPrimitiveDouble(JsonElement element) {
        Double r = GsonHelper.getAsDouble(element);
        return r == null ? 0.0 : r;
    }

    public static Float getAsFloat(JsonElement element) {
        return GsonHelper.isNull(element) ? null : Float.valueOf(element.getAsFloat());
    }

    public static float getAsPrimitiveFloat(JsonElement element) {
        Float r = GsonHelper.getAsFloat(element);
        return r == null ? 0.0f : r.floatValue();
    }
}

