/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.util.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.UUID;
import me.chanjar.weixin.bean.result.WxError;
import me.chanjar.weixin.bean.result.WxQrCodeTicket;
import me.chanjar.weixin.exception.WxErrorException;
import me.chanjar.weixin.util.fs.FileUtils;
import me.chanjar.weixin.util.http.InputStreamResponseHandler;
import me.chanjar.weixin.util.http.RequestExecutor;
import me.chanjar.weixin.util.http.Utf8ResponseHandler;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QrCodeRequestExecutor
implements RequestExecutor<File, WxQrCodeTicket> {
    @Override
    public File execute(String uri, WxQrCodeTicket ticket) throws WxErrorException, ClientProtocolException, IOException {
        HttpGet httpGet;
        CloseableHttpResponse response;
        Header[] contentTypeHeader;
        if (ticket != null) {
            if (uri.indexOf(63) == -1) {
                uri = uri + '?';
            }
            uri = uri + (uri.endsWith("?") ? "ticket=" + URLEncoder.encode(ticket.getTicket(), "UTF-8") : "&ticket=" + URLEncoder.encode(ticket.getTicket(), "UTF-8"));
        }
        if ((contentTypeHeader = (response = httpclient.execute((HttpUriRequest)(httpGet = new HttpGet(uri)))).getHeaders("Content-Type")) != null && contentTypeHeader.length > 0 && ContentType.TEXT_PLAIN.getMimeType().equals(contentTypeHeader[0].getValue())) {
            String responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
            throw new WxErrorException(WxError.fromJson(responseContent));
        }
        InputStream inputStream = (InputStream)InputStreamResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
        File localFile = FileUtils.createTmpFile(inputStream, UUID.randomUUID().toString(), "jpg");
        return localFile;
    }
}

