/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import me.chanjar.weixin.api.WxConfigStorage;
import me.chanjar.weixin.api.WxService;
import me.chanjar.weixin.bean.WxAccessToken;
import me.chanjar.weixin.bean.WxCustomMessage;
import me.chanjar.weixin.bean.WxGroup;
import me.chanjar.weixin.bean.WxMassGroupMessage;
import me.chanjar.weixin.bean.WxMassNews;
import me.chanjar.weixin.bean.WxMassOpenIdsMessage;
import me.chanjar.weixin.bean.WxMassVideo;
import me.chanjar.weixin.bean.WxMenu;
import me.chanjar.weixin.bean.result.WxError;
import me.chanjar.weixin.bean.result.WxMassSendResult;
import me.chanjar.weixin.bean.result.WxMassUploadResult;
import me.chanjar.weixin.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.bean.result.WxQrCodeTicket;
import me.chanjar.weixin.bean.result.WxUser;
import me.chanjar.weixin.bean.result.WxUserList;
import me.chanjar.weixin.exception.WxErrorException;
import me.chanjar.weixin.util.crypto.SHA1;
import me.chanjar.weixin.util.fs.FileUtils;
import me.chanjar.weixin.util.http.MediaDownloadRequestExecutor;
import me.chanjar.weixin.util.http.MediaUploadRequestExecutor;
import me.chanjar.weixin.util.http.QrCodeRequestExecutor;
import me.chanjar.weixin.util.http.RequestExecutor;
import me.chanjar.weixin.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.util.json.GsonHelper;
import me.chanjar.weixin.util.json.WxGsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WxServiceImpl
implements WxService {
    protected static final AtomicBoolean GLOBAL_ACCESS_TOKEN_REFRESH_FLAG = new AtomicBoolean(false);
    protected static final CloseableHttpClient httpclient = HttpClients.createDefault();
    protected WxConfigStorage wxConfigStorage;
    protected final ThreadLocal<Integer> retryTimes = new ThreadLocal();

    @Override
    public boolean checkSignature(String timestamp, String nonce, String signature) {
        try {
            return SHA1.gen(this.wxConfigStorage.getToken(), timestamp, nonce).equals(signature);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accessTokenRefresh() throws WxErrorException {
        block11: {
            if (!GLOBAL_ACCESS_TOKEN_REFRESH_FLAG.getAndSet(true)) {
                try {
                    String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + this.wxConfigStorage.getAppId() + "&secret=" + this.wxConfigStorage.getSecret();
                    try {
                        HttpGet httpGet = new HttpGet(url);
                        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
                        String resultContent = new BasicResponseHandler().handleResponse((HttpResponse)response);
                        WxError error = WxError.fromJson(resultContent);
                        if (error.getErrcode() != 0) {
                            throw new WxErrorException(error);
                        }
                        WxAccessToken accessToken = WxAccessToken.fromJson(resultContent);
                        this.wxConfigStorage.updateAccessToken(accessToken.getAccess_token(), accessToken.getExpires_in());
                        break block11;
                    }
                    catch (ClientProtocolException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    GLOBAL_ACCESS_TOKEN_REFRESH_FLAG.set(false);
                }
            }
            while (GLOBAL_ACCESS_TOKEN_REFRESH_FLAG.get()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public void customMessageSend(WxCustomMessage message) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/message/custom/send";
        this.execute(new SimplePostRequestExecutor(), url, message.toJson());
    }

    @Override
    public void menuCreate(WxMenu menu) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/create";
        this.execute(new SimplePostRequestExecutor(), url, menu.toJson());
    }

    @Override
    public void menuDelete() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/delete";
        this.execute(new SimpleGetRequestExecutor(), url, null);
    }

    @Override
    public WxMenu menuGet() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/get";
        try {
            String resultContent = this.execute(new SimpleGetRequestExecutor(), url, null);
            return WxMenu.fromJson(resultContent);
        }
        catch (WxErrorException e) {
            if (e.getError().getErrcode() == 46003) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public WxMediaUploadResult mediaUpload(String mediaType, String fileType, InputStream inputStream) throws WxErrorException, IOException {
        return this.mediaUpload(mediaType, FileUtils.createTmpFile(inputStream, UUID.randomUUID().toString(), fileType));
    }

    @Override
    public WxMediaUploadResult mediaUpload(String mediaType, File file) throws WxErrorException {
        String url = "http://file.api.weixin.qq.com/cgi-bin/media/upload?type=" + mediaType;
        return this.execute(new MediaUploadRequestExecutor(), url, file);
    }

    @Override
    public File mediaDownload(String media_id) throws WxErrorException {
        String url = "http://file.api.weixin.qq.com/cgi-bin/media/get";
        return this.execute(new MediaDownloadRequestExecutor(), url, "media_id=" + media_id);
    }

    @Override
    public WxMassUploadResult massNewsUpload(WxMassNews news) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/media/uploadnews";
        String responseContent = this.execute(new SimplePostRequestExecutor(), url, news.toJson());
        return WxMassUploadResult.fromJson(responseContent);
    }

    @Override
    public WxMassUploadResult massVideoUpload(WxMassVideo video) throws WxErrorException {
        String url = "http://file.api.weixin.qq.com/cgi-bin/media/uploadvideo";
        String responseContent = this.execute(new SimplePostRequestExecutor(), url, video.toJson());
        return WxMassUploadResult.fromJson(responseContent);
    }

    @Override
    public WxMassSendResult massGroupMessageSend(WxMassGroupMessage message) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/message/mass/sendall";
        String responseContent = this.execute(new SimplePostRequestExecutor(), url, message.toJson());
        return WxMassSendResult.fromJson(responseContent);
    }

    @Override
    public WxMassSendResult massOpenIdsMessageSend(WxMassOpenIdsMessage message) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/message/mass/send";
        String responseContent = this.execute(new SimplePostRequestExecutor(), url, message.toJson());
        return WxMassSendResult.fromJson(responseContent);
    }

    @Override
    public WxGroup groupCreate(String name) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/groups/create";
        JsonObject json = new JsonObject();
        JsonObject groupJson = new JsonObject();
        json.add("group", (JsonElement)groupJson);
        groupJson.addProperty("name", name);
        String responseContent = this.execute(new SimplePostRequestExecutor(), url, json.toString());
        return WxGroup.fromJson(responseContent);
    }

    @Override
    public List<WxGroup> groupGet() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/groups/get";
        String responseContent = this.execute(new SimpleGetRequestExecutor(), url, null);
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        return (List)WxGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement.getAsJsonObject().get("groups"), new TypeToken<List<WxGroup>>(){}.getType());
    }

    @Override
    public long userGetGroup(String openid) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/groups/getid";
        JsonObject o = new JsonObject();
        o.addProperty("openid", openid);
        String responseContent = this.execute(new SimplePostRequestExecutor(), url, o.toString());
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        return GsonHelper.getAsLong(tmpJsonElement.getAsJsonObject().get("groupid"));
    }

    @Override
    public void groupUpdate(WxGroup group) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/groups/update";
        this.execute(new SimplePostRequestExecutor(), url, group.toJson());
    }

    @Override
    public void userUpdateGroup(String openid, long to_groupid) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/groups/members/update";
        JsonObject json = new JsonObject();
        json.addProperty("openid", openid);
        json.addProperty("to_groupid", (Number)to_groupid);
        this.execute(new SimplePostRequestExecutor(), url, json.toString());
    }

    @Override
    public void userUpdateRemark(String openid, String remark) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/user/info/updateremark";
        JsonObject json = new JsonObject();
        json.addProperty("openid", openid);
        json.addProperty("remark", remark);
        this.execute(new SimplePostRequestExecutor(), url, json.toString());
    }

    @Override
    public WxUser userInfo(String openid, String lang) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/user/info";
        lang = lang == null ? "zh_CN" : lang;
        String responseContent = this.execute(new SimpleGetRequestExecutor(), url, "openid=" + openid + "&lang=" + lang);
        return WxUser.fromJson(responseContent);
    }

    @Override
    public WxUserList userList(String next_openid) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/user/get";
        String responseContent = this.execute(new SimpleGetRequestExecutor(), url, next_openid == null ? null : "next_openid=" + next_openid);
        return WxUserList.fromJson(responseContent);
    }

    @Override
    public WxQrCodeTicket qrCodeCreateTmpTicket(int scene_id, Integer expire_seconds) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/qrcode/create";
        JsonObject json = new JsonObject();
        json.addProperty("action_name", "QR_SCENE");
        if (expire_seconds != null) {
            json.addProperty("expire_seconds", (Number)expire_seconds);
        }
        JsonObject actionInfo = new JsonObject();
        JsonObject scene = new JsonObject();
        scene.addProperty("scene_id", (Number)scene_id);
        actionInfo.add("scene", (JsonElement)scene);
        json.add("action_info", (JsonElement)actionInfo);
        String responseContent = this.execute(new SimplePostRequestExecutor(), url, json.toString());
        return WxQrCodeTicket.fromJson(responseContent);
    }

    @Override
    public WxQrCodeTicket qrCodeCreateLastTicket(int scene_id) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/qrcode/create";
        JsonObject json = new JsonObject();
        json.addProperty("action_name", "QR_LIMIT_SCENE");
        JsonObject actionInfo = new JsonObject();
        JsonObject scene = new JsonObject();
        scene.addProperty("scene_id", (Number)scene_id);
        actionInfo.add("scene", (JsonElement)scene);
        json.add("action_info", (JsonElement)actionInfo);
        String responseContent = this.execute(new SimplePostRequestExecutor(), url, json.toString());
        return WxQrCodeTicket.fromJson(responseContent);
    }

    @Override
    public File qrCodePicture(WxQrCodeTicket ticket) throws WxErrorException {
        String url = "https://mp.weixin.qq.com/cgi-bin/showqrcode";
        return this.execute(new QrCodeRequestExecutor(), url, ticket);
    }

    @Override
    public String shortUrl(String long_url) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/shorturl";
        JsonObject o = new JsonObject();
        o.addProperty("action", "long2short");
        o.addProperty("long_url", long_url);
        String responseContent = this.execute(new SimplePostRequestExecutor(), url, o.toString());
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        return tmpJsonElement.getAsJsonObject().get("short_url").getAsString();
    }

    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        if (StringUtils.isBlank((CharSequence)this.wxConfigStorage.getAccessToken())) {
            this.accessTokenRefresh();
        }
        String accessToken = this.wxConfigStorage.getAccessToken();
        String uriWithAccessToken = uri;
        uriWithAccessToken = uriWithAccessToken + (uri.indexOf(63) == -1 ? "?access_token=" + accessToken : "&access_token=" + accessToken);
        try {
            return executor.execute(uriWithAccessToken, data);
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrcode() == 42001 || error.getErrcode() == 40001) {
                this.accessTokenRefresh();
                return this.execute(executor, uri, data);
            }
            if (error.getErrcode() == -1) {
                if (this.retryTimes.get() == null) {
                    this.retryTimes.set(0);
                }
                if (this.retryTimes.get() > 4) {
                    this.retryTimes.set(0);
                    throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
                }
                int sleepMillis = 1000 * (1 << this.retryTimes.get());
                try {
                    System.out.println("\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c" + sleepMillis + "ms\u540e\u91cd\u8bd5");
                    Thread.sleep(sleepMillis);
                    this.retryTimes.set(this.retryTimes.get() + 1);
                    return this.execute(executor, uri, data);
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
            }
            if (error.getErrcode() != 0) {
                throw new WxErrorException(error);
            }
            return null;
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setWxConfigStorage(WxConfigStorage wxConfigProvider) {
        this.wxConfigStorage = wxConfigProvider;
    }
}

