/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import me.chanjar.weixin.api.WxMessageHandler;
import me.chanjar.weixin.api.WxMessageInterceptor;
import me.chanjar.weixin.bean.WxXmlMessage;
import me.chanjar.weixin.bean.WxXmlOutMessage;

public class WxMessageRouter {
    private final List<Rule> rules = new ArrayList<Rule>();
    private final ExecutorService es = Executors.newCachedThreadPool();

    public Rule rule() {
        return new Rule(this);
    }

    public WxXmlOutMessage route(final WxXmlMessage wxMessage) {
        final ArrayList<Rule> matchRules = new ArrayList<Rule>();
        for (Rule rule : this.rules) {
            if (!rule.test(wxMessage)) continue;
            matchRules.add(rule);
        }
        if (matchRules.size() == 0) {
            return null;
        }
        if (((Rule)matchRules.get(0)).async) {
            this.es.submit(new Runnable(){

                public void run() {
                    for (Rule rule : matchRules) {
                        rule.service(wxMessage);
                        if (rule.reEnter) continue;
                        break;
                    }
                }
            });
            return null;
        }
        WxXmlOutMessage res = null;
        for (Rule rule : matchRules) {
            res = rule.service(wxMessage);
            if (rule.reEnter) continue;
            break;
        }
        return res;
    }

    public static class Rule {
        private final WxMessageRouter routerBuilder;
        private boolean async = true;
        private String msgType;
        private String event;
        private String eventKey;
        private String content;
        private String rContent;
        private boolean reEnter = false;
        private List<WxMessageHandler> handlers = new ArrayList<WxMessageHandler>();
        private List<WxMessageInterceptor> interceptors = new ArrayList<WxMessageInterceptor>();

        protected Rule(WxMessageRouter routerBuilder) {
            this.routerBuilder = routerBuilder;
        }

        public Rule async(boolean async) {
            this.async = async;
            return this;
        }

        public Rule msgType(String msgType) {
            this.msgType = msgType;
            return this;
        }

        public Rule event(String event) {
            this.event = event;
            return this;
        }

        public Rule eventKey(String eventKey) {
            this.eventKey = eventKey;
            return this;
        }

        public Rule content(String content) {
            this.content = content;
            return this;
        }

        public Rule rContent(String regex) {
            this.rContent = regex;
            return this;
        }

        public Rule interceptor(WxMessageInterceptor interceptor) {
            return this.interceptor(interceptor, null);
        }

        public Rule interceptor(WxMessageInterceptor interceptor, WxMessageInterceptor ... otherInterceptors) {
            this.interceptors.add(interceptor);
            if (otherInterceptors != null && otherInterceptors.length > 0) {
                for (WxMessageInterceptor i : otherInterceptors) {
                    this.interceptors.add(i);
                }
            }
            return this;
        }

        public Rule handler(WxMessageHandler handler) {
            return this.handler(handler, null);
        }

        public Rule handler(WxMessageHandler handler, WxMessageHandler ... otherHandlers) {
            this.handlers.add(handler);
            if (otherHandlers != null && otherHandlers.length > 0) {
                for (WxMessageHandler i : otherHandlers) {
                    this.handlers.add(i);
                }
            }
            return this;
        }

        public WxMessageRouter end() {
            this.routerBuilder.rules.add(this);
            return this.routerBuilder;
        }

        public WxMessageRouter next() {
            this.reEnter = true;
            return this.end();
        }

        protected boolean test(WxXmlMessage wxMessage) {
            return !(this.msgType != null && !this.msgType.equals(wxMessage.getMsgType()) || this.event != null && !this.event.equals(wxMessage.getEvent()) || this.eventKey != null && !this.eventKey.equals(wxMessage.getEventKey()) || this.content != null && !this.content.equals(wxMessage.getContent() == null ? null : wxMessage.getContent().trim()) || this.rContent != null && !Pattern.matches(this.rContent, wxMessage.getContent() == null ? "" : wxMessage.getContent().trim()));
        }

        protected WxXmlOutMessage service(WxXmlMessage wxMessage) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            for (WxMessageInterceptor interceptor : this.interceptors) {
                if (interceptor.intercept(wxMessage, context)) continue;
                return null;
            }
            WxXmlOutMessage res = null;
            for (WxMessageHandler handler : this.handlers) {
                res = handler.handle(wxMessage, context);
            }
            return res;
        }
    }
}

