/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.chanjar.weixin.mp.bean.WxMpCustomMessage;

public class WxMpCustomMessageGsonAdapter
implements JsonSerializer<WxMpCustomMessage> {
    public JsonElement serialize(WxMpCustomMessage message, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject messageJson = new JsonObject();
        messageJson.addProperty("touser", message.getToUser());
        messageJson.addProperty("msgtype", message.getMsgType());
        if ("text".equals(message.getMsgType())) {
            JsonObject text = new JsonObject();
            text.addProperty("content", message.getContent());
            messageJson.add("text", (JsonElement)text);
        }
        if ("image".equals(message.getMsgType())) {
            JsonObject image = new JsonObject();
            image.addProperty("media_id", message.getMediaId());
            messageJson.add("image", (JsonElement)image);
        }
        if ("voice".equals(message.getMsgType())) {
            JsonObject voice = new JsonObject();
            voice.addProperty("media_id", message.getMediaId());
            messageJson.add("voice", (JsonElement)voice);
        }
        if ("video".equals(message.getMsgType())) {
            JsonObject video = new JsonObject();
            video.addProperty("media_id", message.getMediaId());
            video.addProperty("thumb_media_id", message.getThumbMediaId());
            video.addProperty("title", message.getTitle());
            video.addProperty("description", message.getDescription());
            messageJson.add("video", (JsonElement)video);
        }
        if ("music".equals(message.getMsgType())) {
            JsonObject music = new JsonObject();
            music.addProperty("title", message.getTitle());
            music.addProperty("description", message.getDescription());
            music.addProperty("thumb_media_id", message.getThumbMediaId());
            music.addProperty("musicurl", message.getMusicUrl());
            music.addProperty("hqmusicurl", message.getHqMusicUrl());
            messageJson.add("music", (JsonElement)music);
        }
        if ("news".equals(message.getMsgType())) {
            JsonObject newsJsonObject = new JsonObject();
            JsonArray articleJsonArray = new JsonArray();
            for (WxMpCustomMessage.WxArticle article : message.getArticles()) {
                JsonObject articleJson = new JsonObject();
                articleJson.addProperty("title", article.getTitle());
                articleJson.addProperty("description", article.getDescription());
                articleJson.addProperty("url", article.getUrl());
                articleJson.addProperty("picurl", article.getPicUrl());
                articleJsonArray.add((JsonElement)articleJson);
            }
            newsJsonObject.add("articles", (JsonElement)articleJsonArray);
            messageJson.add("news", (JsonElement)newsJsonObject);
        }
        return messageJson;
    }
}

