/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.http;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.InputStreamResponseHandler;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class MaterialVoiceAndImageDownloadRequestExecutor
implements RequestExecutor<InputStream, String> {
    private File tmpDirFile;

    public MaterialVoiceAndImageDownloadRequestExecutor() {
    }

    public MaterialVoiceAndImageDownloadRequestExecutor(File tmpDirFile) {
        this.tmpDirFile = tmpDirFile;
    }

    public InputStream execute(CloseableHttpClient httpclient, HttpHost httpProxy, String uri, String materialId) throws WxErrorException, ClientProtocolException, IOException {
        HttpPost httpPost = new HttpPost(uri);
        if (httpProxy != null) {
            RequestConfig config = RequestConfig.custom().setProxy(httpProxy).build();
            httpPost.setConfig(config);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("media_id", materialId);
        httpPost.setEntity((HttpEntity)new StringEntity(new Gson().toJson(params)));
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
        InputStream inputStream = (InputStream)InputStreamResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
        byte[] responseContent = IOUtils.toByteArray((InputStream)inputStream);
        String responseContentString = new String(responseContent, "UTF-8");
        if (responseContentString.length() < 100) {
            try {
                WxError wxError = (WxError)new Gson().fromJson(responseContentString, WxError.class);
                if (wxError.getErrorCode() != 0) {
                    throw new WxErrorException(wxError);
                }
            }
            catch (JsonSyntaxException ex) {
                return new ByteArrayInputStream(responseContent);
            }
        }
        return new ByteArrayInputStream(responseContent);
    }
}

