/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.http;

import com.google.gson.Gson;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.Utf8ResponseHandler;
import me.chanjar.weixin.mp.bean.WxMpMaterial;
import me.chanjar.weixin.mp.bean.result.WxMpMaterialUploadResult;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.CloseableHttpClient;

public class MaterialUploadRequestExecutor
implements RequestExecutor<WxMpMaterialUploadResult, WxMpMaterial> {
    public WxMpMaterialUploadResult execute(CloseableHttpClient httpclient, HttpHost httpProxy, String uri, WxMpMaterial material) throws WxErrorException, ClientProtocolException, IOException {
        String responseContent;
        WxError error;
        RequestConfig response;
        HttpPost httpPost = new HttpPost(uri);
        if (httpProxy != null) {
            response = RequestConfig.custom().setProxy(httpProxy).build();
            httpPost.setConfig(response);
        }
        if (material != null) {
            File file = material.getFile();
            if (file == null || !file.exists()) {
                throw new FileNotFoundException();
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.addPart("media", (ContentBody)new InputStreamBody((InputStream)bufferedInputStream, material.getName()));
            Map<String, String> form = material.getForm();
            if (material.getForm() != null) {
                multipartEntityBuilder.addTextBody("description", new Gson().toJson(form));
            }
            httpPost.setEntity(multipartEntityBuilder.build());
            httpPost.setHeader("Content-Type", ContentType.MULTIPART_FORM_DATA.toString());
        }
        if ((error = WxError.fromJson((String)(responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)(response = httpclient.execute((HttpUriRequest)httpPost)))))).getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return WxMpMaterialUploadResult.fromJson(responseContent);
    }
}

