/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import me.chanjar.weixin.common.api.WxErrorExceptionHandler;
import me.chanjar.weixin.common.api.WxMessageDuplicateChecker;
import me.chanjar.weixin.common.api.WxMessageInMemoryDuplicateChecker;
import me.chanjar.weixin.common.session.InternalSession;
import me.chanjar.weixin.common.session.InternalSessionManager;
import me.chanjar.weixin.common.session.StandardSessionManager;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.common.util.LogExceptionHandler;
import me.chanjar.weixin.mp.api.WxMpMessageRouterRule;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.WxMpXmlOutMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WxMpMessageRouter {
    protected final Logger log = LoggerFactory.getLogger(WxMpMessageRouter.class);
    private static final int DEFAULT_THREAD_POOL_SIZE = 100;
    private final List<WxMpMessageRouterRule> rules = new ArrayList<WxMpMessageRouterRule>();
    private final WxMpService wxMpService;
    private ExecutorService executorService;
    private WxMessageDuplicateChecker messageDuplicateChecker;
    private WxSessionManager sessionManager;
    private WxErrorExceptionHandler exceptionHandler;

    public WxMpMessageRouter(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
        this.executorService = Executors.newFixedThreadPool(100);
        this.messageDuplicateChecker = new WxMessageInMemoryDuplicateChecker();
        this.sessionManager = new StandardSessionManager();
        this.exceptionHandler = new LogExceptionHandler();
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setMessageDuplicateChecker(WxMessageDuplicateChecker messageDuplicateChecker) {
        this.messageDuplicateChecker = messageDuplicateChecker;
    }

    public void setSessionManager(WxSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setExceptionHandler(WxErrorExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    List<WxMpMessageRouterRule> getRules() {
        return this.rules;
    }

    public WxMpMessageRouterRule rule() {
        return new WxMpMessageRouterRule(this);
    }

    public WxMpXmlOutMessage route(final WxMpXmlMessage wxMessage) {
        if (this.isDuplicateMessage(wxMessage)) {
            return null;
        }
        ArrayList<WxMpMessageRouterRule> matchRules = new ArrayList<WxMpMessageRouterRule>();
        for (WxMpMessageRouterRule rule : this.rules) {
            if (!rule.test(wxMessage)) continue;
            matchRules.add(rule);
            if (rule.isReEnter()) continue;
            break;
        }
        if (matchRules.size() == 0) {
            return null;
        }
        WxMpXmlOutMessage res = null;
        final ArrayList futures = new ArrayList();
        for (final WxMpMessageRouterRule rule : matchRules) {
            if (rule.isAsync()) {
                futures.add(this.executorService.submit(new Runnable(){

                    public void run() {
                        rule.service(wxMessage, WxMpMessageRouter.this.wxMpService, WxMpMessageRouter.this.sessionManager, WxMpMessageRouter.this.exceptionHandler);
                    }
                }));
                continue;
            }
            res = rule.service(wxMessage, this.wxMpService, this.sessionManager, this.exceptionHandler);
            this.log.debug("End session access: async=false, sessionId={}", (Object)wxMessage.getFromUserName());
            this.sessionEndAccess(wxMessage);
        }
        if (futures.size() > 0) {
            this.executorService.submit(new Runnable(){

                public void run() {
                    for (Future future : futures) {
                        try {
                            future.get();
                            WxMpMessageRouter.this.log.debug("End session access: async=true, sessionId={}", (Object)wxMessage.getFromUserName());
                            WxMpMessageRouter.this.sessionEndAccess(wxMessage);
                        }
                        catch (InterruptedException e) {
                            WxMpMessageRouter.this.log.error("Error happened when wait task finish", (Throwable)e);
                        }
                        catch (ExecutionException e) {
                            WxMpMessageRouter.this.log.error("Error happened when wait task finish", (Throwable)e);
                        }
                    }
                }
            });
        }
        return res;
    }

    protected boolean isDuplicateMessage(WxMpXmlMessage wxMessage) {
        String messageId = "";
        messageId = wxMessage.getMsgId() == null ? String.valueOf(wxMessage.getCreateTime()) + "-" + wxMessage.getFromUserName() + "-" + String.valueOf(wxMessage.getEventKey() == null ? "" : wxMessage.getEventKey()) + "-" + String.valueOf(wxMessage.getEvent() == null ? "" : wxMessage.getEvent()) : String.valueOf(wxMessage.getMsgId());
        return this.messageDuplicateChecker.isDuplicate(messageId);
    }

    protected void sessionEndAccess(WxMpXmlMessage wxMessage) {
        InternalSession session = ((InternalSessionManager)this.sessionManager).findSession(wxMessage.getFromUserName());
        if (session != null) {
            session.endAccess();
        }
    }
}

