/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.cp.bean.WxCpUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WxCpUserGsonAdapter
implements JsonDeserializer<WxCpUser>,
JsonSerializer<WxCpUser> {
    public WxCpUser deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject o = json.getAsJsonObject();
        WxCpUser user = new WxCpUser();
        user.setUserId(GsonHelper.getString((JsonObject)o, (String)"userid"));
        user.setName(GsonHelper.getString((JsonObject)o, (String)"name"));
        if (o.get("department") != null) {
            JsonArray departJsonArray = o.get("department").getAsJsonArray();
            Integer[] departIds = new Integer[departJsonArray.size()];
            int i = 0;
            for (JsonElement jsonElement : departJsonArray) {
                departIds[i++] = jsonElement.getAsInt();
            }
            user.setDepartIds(departIds);
        }
        user.setPosition(GsonHelper.getString((JsonObject)o, (String)"position"));
        user.setMobile(GsonHelper.getString((JsonObject)o, (String)"mobile"));
        Integer gender = GsonHelper.getInteger((JsonObject)o, (String)"gender");
        if (new Integer(1).equals(gender)) {
            user.setGender("\u7537");
        } else if (new Integer(2).equals(gender)) {
            user.setGender("\u5973");
        } else {
            user.setGender("\u672a\u77e5");
        }
        user.setTel(GsonHelper.getString((JsonObject)o, (String)"tel"));
        user.setEmail(GsonHelper.getString((JsonObject)o, (String)"email"));
        user.setWeiXinId(GsonHelper.getString((JsonObject)o, (String)"weixinid"));
        user.setAvatar(GsonHelper.getString((JsonObject)o, (String)"avatar"));
        user.setStatus(GsonHelper.getInteger((JsonObject)o, (String)"status"));
        if (GsonHelper.isNotNull((JsonElement)o.get("extattr"))) {
            JsonArray attrJsonElements = o.get("extattr").getAsJsonObject().get("attrs").getAsJsonArray();
            for (JsonElement attrJsonElement : attrJsonElements) {
                WxCpUser.Attr attr = new WxCpUser.Attr(GsonHelper.getString((JsonObject)attrJsonElement.getAsJsonObject(), (String)"name"), GsonHelper.getString((JsonObject)attrJsonElement.getAsJsonObject(), (String)"value"));
                user.getExtAttrs().add(attr);
            }
        }
        return user;
    }

    public JsonElement serialize(WxCpUser user, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject o = new JsonObject();
        if (user.getUserId() != null) {
            o.addProperty("userid", user.getUserId());
        }
        if (user.getName() != null) {
            o.addProperty("name", user.getName());
        }
        if (user.getDepartIds() != null) {
            JsonArray jsonArray = new JsonArray();
            for (Integer departId : user.getDepartIds()) {
                jsonArray.add((JsonElement)new JsonPrimitive((Number)departId));
            }
            o.add("department", (JsonElement)jsonArray);
        }
        if (user.getPosition() != null) {
            o.addProperty("position", user.getPosition());
        }
        if (user.getMobile() != null) {
            o.addProperty("mobile", user.getMobile());
        }
        if (user.getGender() != null) {
            o.addProperty("gender", (Number)(user.getGender().equals("\u7537") ? 0 : 1));
        }
        if (user.getTel() != null) {
            o.addProperty("tel", user.getTel());
        }
        if (user.getEmail() != null) {
            o.addProperty("email", user.getEmail());
        }
        if (user.getWeiXinId() != null) {
            o.addProperty("weixinid", user.getWeiXinId());
        }
        if (user.getAvatar() != null) {
            o.addProperty("avatar", user.getAvatar());
        }
        if (user.getStatus() != null) {
            o.addProperty("status", (Number)user.getStatus());
        }
        if (user.getExtAttrs().size() > 0) {
            JsonArray attrsJsonArray = new JsonArray();
            for (WxCpUser.Attr attr : user.getExtAttrs()) {
                JsonObject attrJson = new JsonObject();
                attrJson.addProperty("name", attr.getName());
                attrJson.addProperty("value", attr.getValue());
                attrsJsonArray.add((JsonElement)attrJson);
            }
            JsonObject attrsJson = new JsonObject();
            attrsJson.add("attrs", (JsonElement)attrsJsonArray);
            o.add("extattr", (JsonElement)attrsJson);
        }
        return o;
    }
}

