/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.jmh;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.champeau.jmh.JmhParameters;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;

public class ParameterConverter {
    public static void collectParameters(JmhParameters from, List<String> into) {
        ParameterConverter.addOption(into, from.getIncludes(), "");
        ParameterConverter.addIntOption(into, from.getIterations(), "i");
        ParameterConverter.addOption(into, from.getBenchmarkMode(), "bm");
        ParameterConverter.addIntOption(into, from.getBatchSize(), "bs");
        ParameterConverter.addOption(into, from.getExcludes(), "e");
        ParameterConverter.addIntOption(into, from.getFork(), "f");
        ParameterConverter.addBooleanOption(into, from.getFailOnError(), "foe");
        ParameterConverter.addBooleanOption(into, from.getForceGC(), "gc");
        ParameterConverter.addOption(into, from.getJvm(), "jvm");
        ParameterConverter.addOption(into, from.getJvmArgs(), "jvmArgs");
        ParameterConverter.addOption(into, from.getJvmArgsAppend(), "jvmArgsAppend");
        ParameterConverter.addOption(into, from.getJvmArgsPrepend(), "jvmArgsPrepend");
        ParameterConverter.addFileOption(into, from.getHumanOutputFile(), "o");
        ParameterConverter.addIntOption(into, from.getOperationsPerInvocation(), "opi");
        ParameterConverter.addMapOption(into, from.getBenchmarkParameters(), "p");
        ParameterConverter.addRepeatableOption(into, from.getProfilers(), "prof");
        ParameterConverter.addOption(into, from.getTimeOnIteration(), "r");
        ParameterConverter.addOption(into, from.getResultFormat(), "rf");
        ParameterConverter.addFileOption(into, from.getResultsFile(), "rff");
        ParameterConverter.addBooleanOption(into, from.getSynchronizeIterations(), "si");
        ParameterConverter.addIntOption(into, from.getThreads(), "t");
        ParameterConverter.addOption(into, from.getThreadGroups(), "tg");
        ParameterConverter.addOption(into, from.getJmhTimeout(), "to");
        ParameterConverter.addOption(into, from.getTimeUnit(), "tu");
        ParameterConverter.addOption(into, from.getVerbosity(), "v");
        ParameterConverter.addOption(into, from.getWarmup(), "w");
        ParameterConverter.addIntOption(into, from.getWarmupBatchSize(), "wbs");
        ParameterConverter.addIntOption(into, from.getWarmupForks(), "wf");
        ParameterConverter.addIntOption(into, from.getWarmupIterations(), "wi");
        ParameterConverter.addOption(into, from.getWarmupMode(), "wm");
        ParameterConverter.addOption(into, from.getWarmupBenchmarks(), "wmb");
    }

    private static <T> void addOption(List<String> into, Provider<T> str, String option) {
        if (str.isPresent()) {
            into.add("-" + option);
            into.add(String.valueOf(str.get()));
        }
    }

    private static <T> void addOption(List<String> options, ListProperty<T> values, String option) {
        ParameterConverter.addOption(options, values, option, ",");
    }

    private static <T> void addOption(List<String> options, ListProperty<T> values, String option, String separator) {
        List list;
        if (values.isPresent() && !(list = (List)values.get()).isEmpty()) {
            if (!option.isEmpty()) {
                options.add("-" + option);
            }
            String joined = list.stream().map(Object::toString).collect(Collectors.joining(separator));
            options.add(joined);
        }
    }

    private static <T> void addRepeatableOption(List<String> options, ListProperty<T> values, String option) {
        if (values.isPresent()) {
            List listOfValues = (List)values.get();
            for (Object value : listOfValues) {
                options.add("-" + option);
                options.add(String.valueOf(value));
            }
        }
    }

    private static void addBooleanOption(List<String> options, Provider<Boolean> b, String option) {
        if (b.isPresent()) {
            options.add("-" + option);
            options.add((Boolean)b.get() != false ? "1" : "0");
        }
    }

    private static void addIntOption(List<String> options, Provider<Integer> i, String option) {
        if (i.isPresent()) {
            options.add("-" + option);
            options.add(String.valueOf(i.get()));
        }
    }

    private static void addFileOption(List<String> options, RegularFileProperty f, String option) {
        if (f.isPresent()) {
            options.add("-" + option);
            options.add(((File)f.getAsFile().get()).getAbsolutePath());
        }
    }

    private static void addMapOption(List<String> options, MapProperty<String, ListProperty<String>> params, String option) {
        if (params.isPresent()) {
            Map map = (Map)params.get();
            map.forEach((key, listProperty) -> {
                List value = (List)listProperty.get();
                for (String str : value) {
                    options.add(" -" + option);
                    options.add(key + "=" + str);
                }
            });
        }
    }
}

