/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.jmh;

import java.util.ArrayList;
import javax.inject.Inject;
import me.champeau.jmh.JmhParameters;
import me.champeau.jmh.ParameterConverter;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;

public abstract class JMHTask
extends DefaultTask
implements JmhParameters {
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";

    @Inject
    public abstract ExecOperations getExecOperations();

    @Inject
    public abstract ObjectFactory getObjects();

    @Classpath
    public abstract ConfigurableFileCollection getJmhClasspath();

    @Classpath
    public abstract ConfigurableFileCollection getTestRuntimeClasspath();

    @InputFile
    public abstract RegularFileProperty getJarArchive();

    @Override
    @OutputFile
    @Optional
    public abstract RegularFileProperty getHumanOutputFile();

    @Override
    @OutputFile
    public abstract RegularFileProperty getResultsFile();

    @TaskAction
    public void callJmh() {
        ArrayList<String> jmhArgs = new ArrayList<String>();
        ParameterConverter.collectParameters(this, jmhArgs);
        this.getLogger().info("Running JMH with arguments: " + jmhArgs);
        this.getExecOperations().javaexec(spec -> {
            spec.setClasspath(this.computeClasspath());
            spec.getMainClass().set((Object)"org.openjdk.jmh.Main");
            spec.args((Iterable)jmhArgs);
            spec.systemProperty(JAVA_IO_TMPDIR, (Object)this.getTemporaryDir().getAbsolutePath());
            Property javaLauncher = this.getJavaLauncher();
            if (javaLauncher.isPresent()) {
                spec.executable((Object)((JavaLauncher)javaLauncher.get()).getExecutablePath().getAsFile());
            }
        });
    }

    private FileCollection computeClasspath() {
        ConfigurableFileCollection classpath = this.getObjects().fileCollection();
        classpath.from(new Object[]{this.getJmhClasspath()});
        classpath.from(new Object[]{this.getJarArchive()});
        classpath.from(new Object[]{this.getTestRuntimeClasspath()});
        return classpath;
    }
}

