/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.jmh;

import javax.inject.Inject;
import me.champeau.jmh.JmhBytecodeGeneratorRunnable;
import me.champeau.jmh.WithJavaToolchain;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class JmhBytecodeGeneratorTask
extends DefaultTask
implements WithJavaToolchain {
    @Inject
    public abstract WorkerExecutor getWorkerExecutor();

    @Input
    public abstract ListProperty<String> getJvmArgs();

    @Input
    public abstract Property<String> getGeneratorType();

    @Classpath
    public abstract ConfigurableFileCollection getJmhClasspath();

    @Classpath
    public abstract ConfigurableFileCollection getRuntimeClasspath();

    @Classpath
    public abstract ConfigurableFileCollection getClassesDirsToProcess();

    @OutputDirectory
    public abstract DirectoryProperty getGeneratedClassesDir();

    @OutputDirectory
    public abstract DirectoryProperty getGeneratedSourcesDir();

    @TaskAction
    public void generate() {
        this.getWorkerExecutor().processIsolation(process -> {
            if (this.getJavaLauncher().isPresent()) {
                process.getForkOptions().executable((Object)((JavaLauncher)this.getJavaLauncher().get()).getExecutablePath().getAsFile());
            }
            process.getClasspath().setFrom((Iterable)this.getJmhClasspath());
            process.getForkOptions().jvmArgs((Iterable)this.getJvmArgs().get());
        }).submit(JmhBytecodeGeneratorRunnable.class, params -> {
            params.getClasspath().from(new Object[]{this.getRuntimeClasspath()});
            params.getGeneratorType().set(this.getGeneratorType());
            params.getOutputSourceDirectory().set((Provider)this.getGeneratedSourcesDir());
            params.getOutputResourceDirectory().set((Provider)this.getGeneratedClassesDir());
            params.getClassesDirsToProcess().from(new Object[]{this.getClassesDirsToProcess()});
        });
    }
}

