/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.jmh;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.champeau.jmh.BytecodeGeneratorWorkParameters;
import org.gradle.workers.WorkAction;
import org.openjdk.jmh.generators.asm.ASMGeneratorSource;
import org.openjdk.jmh.generators.core.BenchmarkGenerator;
import org.openjdk.jmh.generators.core.FileSystemDestination;
import org.openjdk.jmh.generators.core.GeneratorDestination;
import org.openjdk.jmh.generators.core.GeneratorSource;
import org.openjdk.jmh.generators.core.SourceError;
import org.openjdk.jmh.generators.reflection.RFGeneratorSource;
import org.openjdk.jmh.util.FileUtils;

public abstract class JmhBytecodeGeneratorRunnable
implements WorkAction<BytecodeGeneratorWorkParameters> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        BytecodeGeneratorWorkParameters params = (BytecodeGeneratorWorkParameters)this.getParameters();
        File outputSourceDirectory = (File)params.getOutputSourceDirectory().getAsFile().get();
        File outputResourceDirectory = (File)params.getOutputResourceDirectory().getAsFile().get();
        JmhBytecodeGeneratorRunnable.cleanup(outputSourceDirectory);
        JmhBytecodeGeneratorRunnable.cleanup(outputResourceDirectory);
        String generatorType = (String)params.getGeneratorType().get();
        if (generatorType.equals("default")) {
            generatorType = "reflection";
        }
        Set classpath = params.getClasspath().getFiles();
        Set compiledBytecodeDirectories = params.getClassesDirsToProcess().getFiles();
        HashSet allFiles = new HashSet();
        allFiles.addAll(classpath);
        allFiles.addAll(compiledBytecodeDirectories);
        URL[] urls = (URL[])allFiles.stream().map(JmhBytecodeGeneratorRunnable::toURL).filter(Objects::nonNull).toArray(URL[]::new);
        URLClassLoader loader = new URLClassLoader(urls, this.getClass().getClassLoader());
        ClassLoader ocl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            FileSystemDestination destination = new FileSystemDestination(outputResourceDirectory, outputSourceDirectory);
            HashMap<File, Collection> allClasses = new HashMap<File, Collection>(urls.length);
            for (File file : compiledBytecodeDirectories) {
                Collection classes = FileUtils.getClasses((File)file);
                System.out.println("Processing " + classes.size() + " classes from " + file + " with \"" + generatorType + "\" generator");
                allClasses.put(file, classes);
            }
            System.out.println("Writing out Java source to " + outputSourceDirectory + " and resources to " + outputResourceDirectory);
            for (Map.Entry entry : allClasses.entrySet()) {
                ASMGeneratorSource src;
                File compiledBytecodeDirectory = (File)entry.getKey();
                Collection classes = (Collection)entry.getValue();
                ASMGeneratorSource source = null;
                if (generatorType.equalsIgnoreCase("asm")) {
                    src = new ASMGeneratorSource();
                    try {
                        src.processClasses(classes);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    source = src;
                } else if (generatorType.equalsIgnoreCase("reflection")) {
                    src = new RFGeneratorSource();
                    for (File f : classes) {
                        String name = f.getAbsolutePath().substring(compiledBytecodeDirectory.getAbsolutePath().length() + 1);
                        name = name.replaceAll("\\\\", ".");
                        if (!(name = name.replaceAll("/", ".")).endsWith(".class")) continue;
                        try {
                            src.processClasses(new Class[]{Class.forName(name.substring(0, name.length() - 6), false, loader)});
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    source = src;
                }
                BenchmarkGenerator gen = new BenchmarkGenerator();
                gen.generate((GeneratorSource)source, (GeneratorDestination)destination);
                gen.complete((GeneratorSource)source, (GeneratorDestination)destination);
            }
            if (destination.hasErrors()) {
                int errCount = 0;
                StringBuilder stringBuilder = new StringBuilder();
                for (SourceError e : destination.getErrors()) {
                    ++errCount;
                    stringBuilder.append("  - ").append(e.toString()).append("\n");
                }
                throw new RuntimeException("Generation of JMH bytecode failed with " + errCount + " errors:\n" + stringBuilder);
            }
        }
        finally {
            try {
                loader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Thread.currentThread().setContextClassLoader(ocl);
        }
    }

    private static URL toURL(File f) {
        try {
            return f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static void cleanup(File file) {
        if (file.exists()) {
            File[] listing = file.listFiles();
            if (listing != null) {
                for (File sub : listing) {
                    JmhBytecodeGeneratorRunnable.cleanup(sub);
                }
            }
            file.delete();
        }
    }
}

