/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.jmh;

import me.champeau.jmh.JmhParameters;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.provider.Provider;

class DefaultsConfigurer {
    DefaultsConfigurer() {
    }

    public static void configureDefaults(JmhParameters params, Project project) {
        params.getJmhVersion().convention((Object)"1.28");
        params.getIncludeTests().convention((Object)true);
        params.getZip64().convention((Object)false);
        params.getDuplicateClassesStrategy().convention((Object)DuplicatesStrategy.INCLUDE);
        params.getFailOnError().convention((Object)false);
        params.getForceGC().convention((Object)false);
        params.getResultFormat().convention((Object)"text");
        params.getResultsFile().convention(project.getProviders().zip(params.getResultFormat(), (Provider)project.getLayout().getBuildDirectory(), (format, dir) -> dir.file("results/" + DefaultsConfigurer.nameOf(params) + "/results." + DefaultsConfigurer.extensionFor(format))));
        params.getHumanOutputFile().convention(project.getProviders().zip(params.getResultFormat(), (Provider)project.getLayout().getBuildDirectory(), (format, dir) -> dir.file("results/" + DefaultsConfigurer.nameOf(params) + "/results." + DefaultsConfigurer.extensionFor(format))));
    }

    private static String nameOf(JmhParameters params) {
        if (params instanceof Named) {
            return ((Named)params).getName();
        }
        return "jmh";
    }

    private static String extensionFor(String format) {
        if ("TEXT".equalsIgnoreCase(format)) {
            return "txt";
        }
        return format.toLowerCase();
    }

    public static void configureConvention(JmhParameters from, JmhParameters into) {
        into.getJmhVersion().convention(from.getJmhVersion());
        into.getIncludeTests().convention(from.getIncludeTests());
        into.getIncludes().convention(from.getIncludes());
        into.getExcludes().convention(from.getExcludes());
        into.getBenchmarkMode().convention(from.getBenchmarkMode());
        into.getIterations().convention(from.getIterations());
        into.getBatchSize().convention(from.getBatchSize());
        into.getFork().convention(from.getFork());
        into.getFailOnError().convention(from.getFailOnError());
        into.getForceGC().convention(from.getForceGC());
        into.getJvm().convention(from.getJvm());
        into.getJvmArgs().convention(from.getJvmArgs());
        into.getJvmArgsAppend().convention(from.getJvmArgsAppend());
        into.getJvmArgsPrepend().convention(from.getJvmArgsPrepend());
        into.getOperationsPerInvocation().convention(from.getOperationsPerInvocation());
        into.getBenchmarkParameters().convention(from.getBenchmarkParameters());
        into.getProfilers().convention(from.getProfilers());
        into.getTimeOnIteration().convention(from.getTimeOnIteration());
        into.getResultExtension().convention(from.getResultExtension());
        into.getResultFormat().convention(from.getResultFormat());
        into.getSynchronizeIterations().convention(from.getSynchronizeIterations());
        into.getThreads().convention(from.getThreads());
        into.getThreadGroups().convention(from.getThreadGroups());
        into.getTimeUnit().convention(from.getTimeUnit());
        into.getVerbosity().convention(from.getVerbosity());
        into.getJmhTimeout().convention(from.getJmhTimeout());
        into.getWarmup().convention(from.getWarmup());
        into.getWarmupBatchSize().convention(from.getWarmupBatchSize());
        into.getWarmupForks().convention(from.getWarmupForks());
        into.getWarmupIterations().convention(from.getWarmupIterations());
        into.getWarmupMode().convention(from.getWarmupMode());
        into.getWarmupBenchmarks().convention(from.getWarmupBenchmarks());
        into.getZip64().convention(from.getZip64());
        into.getDuplicateClassesStrategy().convention(from.getDuplicateClassesStrategy());
        into.getJavaLauncher().convention(from.getJavaLauncher());
    }
}

